/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.resource.spi.AbstractResource;

public final class ManifestBuilder {
    private final Map<String, String> identityRequirements = new LinkedHashMap<String, String>();
    private final List<String> genericCapabilities = new ArrayList<String>();
    private final List<String> genericRequirements = new ArrayList<String>();
    private List<String> lines = new ArrayList<String>();
    private Manifest manifest;

    public ManifestBuilder() {
        this("1.0");
    }

    public ManifestBuilder(String manifestVersion) {
        if (manifestVersion != null) {
            this.append(Attributes.Name.MANIFEST_VERSION + ": " + manifestVersion);
        }
    }

    public ManifestBuilder addIdentityCapability(ResourceIdentity identity) {
        return this.addIdentityCapability(identity.getSymbolicName(), identity.getVersion());
    }

    public ManifestBuilder addIdentityCapability(String symbolicName, String version) {
        return this.addIdentityCapability(symbolicName, Version.parseVersion(version), null, null);
    }

    public ManifestBuilder addIdentityCapability(String symbolicName, Version version) {
        return this.addIdentityCapability(symbolicName, version, null, null);
    }

    public ManifestBuilder addIdentityCapability(String symbolicName, Version version, Map<String, String> atts, Map<String, String> dirs) {
        StringBuffer buffer = new StringBuffer(symbolicName);
        if (version != null) {
            buffer.append(";version=\"" + version + "\"");
        }
        if (atts != null) {
            for (Map.Entry<String, String> entry : atts.entrySet()) {
                buffer.append(";" + entry.getKey() + "=\"" + entry.getValue() + "\"");
            }
        }
        if (dirs != null) {
            for (Map.Entry<String, String> entry : dirs.entrySet()) {
                buffer.append(";" + entry.getKey() + ":=\"" + entry.getValue() + "\"");
            }
        }
        this.addManifestHeader("Gravia-Identity", buffer.toString());
        return this;
    }

    public ManifestBuilder addIdentityRequirement(String symbolicName, String version) {
        return this.addIdentityRequirement(symbolicName, new VersionRange(version), null, null);
    }

    public ManifestBuilder addIdentityRequirement(String symbolicName, VersionRange version) {
        return this.addIdentityRequirement(symbolicName, version, null, null);
    }

    public ManifestBuilder addIdentityRequirement(String symbolicName, VersionRange version, Map<String, String> atts, Map<String, String> dirs) {
        StringBuffer buffer = new StringBuffer(symbolicName);
        if (version != null) {
            buffer.append(";version=\"" + version + "\"");
        }
        if (atts != null) {
            for (Map.Entry<String, String> entry : atts.entrySet()) {
                buffer.append(";" + entry.getKey() + "=\"" + entry.getValue() + "\"");
            }
        }
        if (dirs != null) {
            for (Map.Entry<String, String> entry : dirs.entrySet()) {
                buffer.append(";" + entry.getKey() + ":=\"" + entry.getValue() + "\"");
            }
        }
        this.addEntry(this.identityRequirements, buffer.toString());
        return this;
    }

    public ManifestBuilder addManifestHeader(String key, String value) {
        this.append(key + ": " + value);
        return this;
    }

    public ManifestBuilder addModuleActivator(String className) {
        this.addManifestHeader("Module-Activator", className);
        return this;
    }

    public ManifestBuilder addModuleActivator(Class<?> clazz) {
        this.addManifestHeader("Module-Activator", clazz.getName());
        return this;
    }

    public ManifestBuilder addGenericCapabilities(String ... capabilities) {
        for (String entry : capabilities) {
            this.genericCapabilities.add(entry);
        }
        return this;
    }

    public ManifestBuilder addGenericCapability(String namespace, Map<String, String> atts, Map<String, String> dirs) {
        this.genericCapabilities.add(this.getCapabilitySpec(namespace, atts, dirs));
        return this;
    }

    public ManifestBuilder addGenericRequirements(String ... capabilities) {
        for (String entry : capabilities) {
            this.genericRequirements.add(entry);
        }
        return this;
    }

    public ManifestBuilder addGenericRequirement(String namespace, Map<String, String> atts, Map<String, String> dirs) {
        this.genericRequirements.add(this.getCapabilitySpec(namespace, atts, dirs));
        return this;
    }

    private String getCapabilitySpec(String namespace, Map<String, String> atts, Map<String, String> dirs) {
        StringBuffer buffer = new StringBuffer(namespace);
        if (atts != null) {
            for (Map.Entry<String, String> entry : atts.entrySet()) {
                buffer.append(";" + entry.getKey() + "=\"" + entry.getValue() + "\"");
            }
        }
        if (dirs != null) {
            for (Map.Entry<String, String> entry : dirs.entrySet()) {
                buffer.append(";" + entry.getKey() + ":=\"" + entry.getValue() + "\"");
            }
        }
        return buffer.toString();
    }

    private void addEntry(Map<String, String> target, String entry) {
        String key = entry;
        int index = entry.indexOf(";");
        if (index > 0) {
            key = entry.substring(0, index);
        }
        if (target.get(key) == null) {
            target.put(key, entry);
        } else {
            AbstractResource.LOGGER.warn("Ignore duplicate entery: {}", (Object)entry);
        }
    }

    public static boolean isValidManifest(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        try {
            ManifestBuilder.validateManifest(manifest);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static void validateManifest(Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException("Null manifest");
        }
        String identitySpec = ManifestBuilder.getManifestHeaderInternal(manifest, "Gravia-Identity");
        if (identitySpec == null) {
            throw new IllegalArgumentException("Cannot obtain required header: Gravia-Identity");
        }
    }

    private static String getManifestHeaderInternal(Manifest manifest, String key) {
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value != null ? value.trim() : null;
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            this.addManifestHeader("Gravia-IdentityRequirement", this.identityRequirements);
            this.addManifestHeader("Gravia-Capability", this.genericCapabilities);
            this.addManifestHeader("Gravia-Requirement", this.genericRequirements);
            StringWriter out = new StringWriter();
            PrintWriter pw = new PrintWriter(out);
            for (String line : this.lines) {
                byte[] bytes = line.getBytes();
                while (bytes.length >= 512) {
                    byte[] head = Arrays.copyOf(bytes, 256);
                    bytes = Arrays.copyOfRange(bytes, 256, bytes.length);
                    pw.println(new String(head));
                    pw.print(" ");
                }
                pw.println(new String(bytes));
            }
            String content = out.toString();
            if (AbstractResource.LOGGER.isTraceEnabled()) {
                AbstractResource.LOGGER.trace(content);
            }
            try {
                this.manifest = new Manifest(new ByteArrayInputStream(content.getBytes()));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot create manifest", ex);
            }
        }
        return this.manifest;
    }

    private void addManifestHeader(String header, Map<String, String> source) {
        if (source.size() > 0) {
            int i = 0;
            StringBuffer buffer = new StringBuffer();
            for (String entry : source.values()) {
                buffer.append(i++ > 0 ? "," : "");
                buffer.append(entry);
            }
            this.addManifestHeader(header, buffer.toString());
        }
    }

    private void addManifestHeader(String header, List<String> source) {
        if (source.size() > 0) {
            int i = 0;
            StringBuffer buffer = new StringBuffer();
            for (String entry : source) {
                buffer.append(i++ > 0 ? "," : "");
                buffer.append(entry);
            }
            this.addManifestHeader(header, buffer.toString());
        }
    }

    public InputStream openStream() {
        Manifest manifest = this.getManifest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            manifest.write(baos);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot provide manifest input stream", ex);
        }
    }

    public void append(String line) {
        if (this.manifest != null) {
            throw new IllegalStateException("Cannot append to existing manifest");
        }
        this.lines.add(line);
    }

    public static enum Type {
        String,
        Version,
        VersionRange,
        Long,
        Double;

    }
}

