/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resolver.spi;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resource.MatchPolicy;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.Wiring;
import org.jboss.gravia.resource.spi.AbstractResourceStore;

public abstract class AbstractEnvironment
extends AbstractResourceStore
implements Environment {
    private final Map<Resource, Wiring> wirings = new ConcurrentHashMap<Resource, Wiring>();

    public AbstractEnvironment(String storeName, MatchPolicy matchPolicy) {
        super(storeName, matchPolicy);
    }

    public static AbstractEnvironment assertAbstractEnvironment(Environment env) {
        if (!(env instanceof AbstractEnvironment)) {
            throw new IllegalArgumentException("Not an AbstractEnvironment: " + env);
        }
        return (AbstractEnvironment)env;
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        return Collections.unmodifiableMap(this.wirings);
    }

    public void putWiring(Resource resource, Wiring wiring) {
        this.wirings.put(resource, wiring);
    }
}

