/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.AttachmentKey;
import org.jboss.gravia.resource.ManifestResourceBuilder;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.spi.AttachableSupport;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.ResourceAssociation;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.util.ManifestHeadersProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WebAppContextListener
implements ServletContextListener {
    public static final AttachmentKey<ServletContext> SERVLET_CONTEXT_KEY = AttachmentKey.create(ServletContext.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext;
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule((servletContext = event.getServletContext()).getClassLoader());
        if (module == null) {
            module = this.installWebappModule(servletContext);
        }
        if (module != null) {
            servletContext.setAttribute(Module.class.getName(), (Object)module);
            try {
                module.start();
            }
            catch (ModuleException ex) {
                throw new IllegalStateException(ex);
            }
            BundleContext bundleContext = module.adapt(Bundle.class).getBundleContext();
            servletContext.setAttribute("org.osgi.framework.BundleContext", (Object)bundleContext);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        Module module = (Module)servletContext.getAttribute(Module.class.getName());
        if (module != null && module.getState() != Module.State.UNINSTALLED) {
            module.uninstall();
        }
    }

    public Module installWebappModule(ServletContext servletContext) {
        Manifest manifest = this.getWebappManifest(servletContext);
        if (manifest == null) {
            return null;
        }
        ManifestResourceBuilder resbuilder = new ManifestResourceBuilder().load(manifest);
        if (!resbuilder.isValid()) {
            return null;
        }
        Resource resource = resbuilder.getResource();
        Dictionary<String, String> headers = new ManifestHeadersProvider(manifest).getHeaders();
        return this.installWebappModule(servletContext, resource, headers);
    }

    public Module installWebappModule(ServletContext servletContext, Resource resource, Dictionary<String, String> headers) {
        Module module;
        ResourceIdentity identity = resource.getIdentity();
        Resource association = ResourceAssociation.getResource(identity);
        resource = association != null ? association : resource;
        AttachableSupport context = new AttachableSupport();
        context.putAttachment(SERVLET_CONTEXT_KEY, (Object)servletContext);
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            ClassLoader classLoader = servletContext.getClassLoader();
            module = runtime.installModule(classLoader, resource, headers, (Attachable)context);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ModuleException ex) {
            throw new IllegalStateException(ex);
        }
        return module;
    }

    private Manifest getWebappManifest(ServletContext servletContext) {
        Manifest manifest = null;
        try {
            URL entry = servletContext.getResource("/META-INF/MANIFEST.MF");
            if (entry != null) {
                manifest = new Manifest(entry.openStream());
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read manifest", ex);
        }
        return manifest;
    }
}

