/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.gravia.provision.DefaultProvisioner;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.internal.BundleContextResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class ProvisionerActivator
implements BundleActivator {
    private ServiceRegistration<Provisioner> registration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        ServiceReference repref;
        Bundle bundle = context.getBundle();
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(bundle.getBundleId());
        final ModuleContext syscontext = module.getModuleContext();
        final CountDownLatch latch = new CountDownLatch(2);
        final AtomicReference<Object> resolverRef = new AtomicReference<Object>();
        final AtomicReference<Object> repositoryRef = new AtomicReference<Object>();
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    ServiceReference sref = event.getServiceReference();
                    String[] objectClass = (String[])sref.getProperty("objectClass");
                    if (Resolver.class.getName().equals(objectClass[0])) {
                        resolverRef.set((Resolver)syscontext.getService(sref));
                        latch.countDown();
                    }
                    if (Repository.class.getName().equals(objectClass[0])) {
                        repositoryRef.set((Repository)syscontext.getService(sref));
                        latch.countDown();
                    }
                }
            }
        };
        syscontext.addServiceListener(listener);
        ServiceReference resref = syscontext.getServiceReference(Resolver.class);
        if (resref != null) {
            resolverRef.set(syscontext.getService(resref));
            latch.countDown();
        }
        if ((repref = syscontext.getServiceReference(Repository.class)) != null) {
            repositoryRef.set(syscontext.getService(repref));
            latch.countDown();
        }
        try {
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                String name = resolverRef.get() == null ? Resolver.class.getName() : Repository.class.getName();
                throw new TimeoutException("Cannot obtain " + name + " service");
            }
        }
        finally {
            syscontext.removeServiceListener(listener);
        }
        RuntimeEnvironment environment = new RuntimeEnvironment(runtime).initDefaultContent();
        BundleContextResourceInstaller installer = new BundleContextResourceInstaller(context, environment);
        DefaultProvisioner provisioner = new DefaultProvisioner((Environment)environment, (Resolver)resolverRef.get(), (Repository)repositoryRef.get(), installer);
        this.registration = syscontext.registerService(Provisioner.class, (Object)provisioner, null);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

