/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.ProcessDestroyer;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Execute {
    public static final int INVALID = Integer.MAX_VALUE;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String[] cmdl = null;
    private String[] env = null;
    private int exitValue = Integer.MAX_VALUE;
    private ExecuteStreamHandler streamHandler;
    private ExecuteWatchdog watchdog;
    private File workingDirectory = null;
    private Project project = null;
    private boolean newEnvironment = false;
    private boolean spawn = false;
    private boolean useVMLauncher = true;
    private static String antWorkingDirectory = System.getProperty("user.dir");
    private static CommandLauncher vmLauncher = null;
    private static CommandLauncher shellLauncher = null;
    private static Vector procEnvironment = null;
    private static ProcessDestroyer processDestroyer = new ProcessDestroyer();
    private static boolean environmentCaseInSensitive = false;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Runtime;

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public static synchronized Vector getProcEnvironment() {
        if (procEnvironment != null) {
            return procEnvironment;
        }
        procEnvironment = new Vector();
        try {
            String line;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Execute exe = new Execute(new PumpStreamHandler(out));
            exe.setCommandline(Execute.getProcEnvCommand());
            exe.setNewenvironment(true);
            int retval = exe.execute();
            if (retval != 0) {
                // empty if block
            }
            BufferedReader in = new BufferedReader(new StringReader(Execute.toString(out)));
            if (Os.isFamily("openvms")) {
                procEnvironment = Execute.addVMSLogicals(procEnvironment, in);
                return procEnvironment;
            }
            String var = null;
            String lineSep = StringUtils.LINE_SEP;
            while ((line = in.readLine()) != null) {
                if (line.indexOf(61) == -1) {
                    if (var == null) {
                        var = lineSep + line;
                        continue;
                    }
                    var = var + lineSep + line;
                    continue;
                }
                if (var != null) {
                    procEnvironment.addElement(var);
                }
                var = line;
            }
            if (var != null) {
                procEnvironment.addElement(var);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        return procEnvironment;
    }

    private static String[] getProcEnvCommand() {
        if (Os.isFamily("os/2")) {
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("windows")) {
            if (Os.isFamily("win9x")) {
                return new String[]{"command.com", "/c", "set"};
            }
            return new String[]{"cmd", "/c", "set"};
        }
        if (Os.isFamily("z/os") || Os.isFamily("unix")) {
            String[] cmd = new String[]{new File("/bin/env").canRead() ? "/bin/env" : (new File("/usr/bin/env").canRead() ? "/usr/bin/env" : "env")};
            return cmd;
        }
        if (Os.isFamily("netware") || Os.isFamily("os/400")) {
            return new String[]{"env"};
        }
        if (Os.isFamily("openvms")) {
            return new String[]{"show", "logical"};
        }
        return null;
    }

    public static String toString(ByteArrayOutputStream bos) {
        if (Os.isFamily("z/os")) {
            try {
                return bos.toString("Cp1047");
            }
            catch (UnsupportedEncodingException e) {
            }
        } else if (Os.isFamily("os/400")) {
            try {
                return bos.toString("Cp500");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return bos.toString();
    }

    public Execute() {
        this(new PumpStreamHandler(), null);
    }

    public Execute(ExecuteStreamHandler streamHandler) {
        this(streamHandler, null);
    }

    public Execute(ExecuteStreamHandler streamHandler, ExecuteWatchdog watchdog) {
        this.setStreamHandler(streamHandler);
        this.watchdog = watchdog;
        if (Os.isFamily("openvms")) {
            this.useVMLauncher = false;
        }
    }

    public void setStreamHandler(ExecuteStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
    }

    public String[] getCommandline() {
        return this.cmdl;
    }

    public void setCommandline(String[] commandline) {
        this.cmdl = commandline;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public String[] getEnvironment() {
        return this.env == null || this.newEnvironment ? this.env : this.patchEnvironment();
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public void setWorkingDirectory(File wd) {
        this.workingDirectory = wd == null || wd.getAbsolutePath().equals(antWorkingDirectory) ? null : wd;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory == null ? new File(antWorkingDirectory) : this.workingDirectory;
    }

    public void setAntRun(Project project) throws BuildException {
        this.project = project;
    }

    public void setVMLauncher(boolean useVMLauncher) {
        this.useVMLauncher = useVMLauncher;
    }

    public static Process launch(Project project, String[] command, String[] env, File dir, boolean useVM) throws IOException {
        if (dir != null && !dir.exists()) {
            throw new BuildException(dir + " doesn't exist.");
        }
        CommandLauncher launcher = useVM && vmLauncher != null ? vmLauncher : shellLauncher;
        return launcher.exec(project, command, env, dir);
    }

    public int execute() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        try {
            this.streamHandler.setProcessInputStream(process.getOutputStream());
            this.streamHandler.setProcessOutputStream(process.getInputStream());
            this.streamHandler.setProcessErrorStream(process.getErrorStream());
        }
        catch (IOException e) {
            process.destroy();
            throw e;
        }
        this.streamHandler.start();
        try {
            processDestroyer.add(process);
            if (this.watchdog != null) {
                this.watchdog.start(process);
            }
            this.waitFor(process);
            if (this.watchdog != null) {
                this.watchdog.stop();
            }
            this.streamHandler.stop();
            Execute.closeStreams(process);
            if (this.watchdog != null) {
                this.watchdog.checkException();
            }
            int e = this.getExitValue();
            return e;
        }
        catch (ThreadDeath t) {
            process.destroy();
            throw t;
        }
        finally {
            processDestroyer.remove(process);
        }
    }

    public void spawn() throws IOException {
        if (this.workingDirectory != null && !this.workingDirectory.exists()) {
            throw new BuildException(this.workingDirectory + " doesn't exist.");
        }
        Process process = Execute.launch(this.project, this.getCommandline(), this.getEnvironment(), this.workingDirectory, this.useVMLauncher);
        if (Os.isFamily("windows")) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.project.log("interruption in the sleep after having spawned a process", 3);
            }
        }
        OutputStream dummyOut = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        PumpStreamHandler handler = new PumpStreamHandler(dummyOut);
        handler.setProcessErrorStream(process.getErrorStream());
        handler.setProcessOutputStream(process.getInputStream());
        handler.start();
        process.getOutputStream().close();
        this.project.log("spawned process " + process.toString(), 3);
    }

    protected void waitFor(Process process) {
        try {
            process.waitFor();
            this.setExitValue(process.exitValue());
        }
        catch (InterruptedException e) {
            process.destroy();
        }
    }

    protected void setExitValue(int value) {
        this.exitValue = value;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public static boolean isFailure(int exitValue) {
        return Os.isFamily("openvms") ? exitValue % 2 == 0 : exitValue != 0;
    }

    public boolean isFailure() {
        return Execute.isFailure(this.getExitValue());
    }

    public boolean killedProcess() {
        return this.watchdog != null && this.watchdog.killedProcess();
    }

    private String[] patchEnvironment() {
        if (Os.isFamily("openvms")) {
            return this.env;
        }
        Vector osEnv = (Vector)Execute.getProcEnvironment().clone();
        for (int i = 0; i < this.env.length; ++i) {
            String keyValue = this.env[i];
            String key = keyValue.substring(0, keyValue.indexOf(61) + 1);
            if (environmentCaseInSensitive) {
                key = key.toLowerCase();
            }
            int size = osEnv.size();
            for (int j = 0; j < size; ++j) {
                String convertedItem;
                String osEnvItem = (String)osEnv.elementAt(j);
                String string = convertedItem = environmentCaseInSensitive ? osEnvItem.toLowerCase() : osEnvItem;
                if (!convertedItem.startsWith(key)) continue;
                osEnv.removeElementAt(j);
                if (!environmentCaseInSensitive) break;
                keyValue = osEnvItem.substring(0, key.length()) + keyValue.substring(key.length());
                break;
            }
            osEnv.addElement(keyValue);
        }
        return osEnv.toArray(new String[osEnv.size()]);
    }

    public static void runCommand(Task task, String[] cmdline) throws BuildException {
        try {
            task.log(Commandline.describeCommand(cmdline), 3);
            Execute exe = new Execute(new LogStreamHandler(task, 2, 0));
            exe.setAntRun(task.getProject());
            exe.setCommandline(cmdline);
            int retval = exe.execute();
            if (Execute.isFailure(retval)) {
                throw new BuildException(cmdline[0] + " failed with return code " + retval, task.getLocation());
            }
        }
        catch (IOException exc) {
            throw new BuildException("Could not launch " + cmdline[0] + ": " + exc, task.getLocation());
        }
    }

    public static void closeStreams(Process process) {
        FileUtils.close(process.getInputStream());
        FileUtils.close(process.getOutputStream());
        FileUtils.close(process.getErrorStream());
    }

    private static Vector addVMSLogicals(Vector environment, BufferedReader in) throws IOException {
        HashMap<String, String> logicals = new HashMap<String, String>();
        String logName = null;
        String logValue = null;
        String line = null;
        while ((line = in.readLine()) != null) {
            int eqIndex;
            String newLogName;
            if (line.startsWith("\t=")) {
                if (logName == null) continue;
                logValue = logValue + "," + line.substring(4, line.length() - 1);
                continue;
            }
            if (!line.startsWith("  \"")) continue;
            if (logName != null) {
                logicals.put(logName, logValue);
            }
            if (logicals.containsKey(newLogName = line.substring(3, (eqIndex = line.indexOf(61)) - 2))) {
                logName = null;
                continue;
            }
            logName = newLogName;
            logValue = line.substring(eqIndex + 3, line.length() - 1);
        }
        if (logName != null) {
            logicals.put(logName, logValue);
        }
        Iterator i = logicals.keySet().iterator();
        while (i.hasNext()) {
            String logical = (String)i.next();
            environment.add(logical + "=" + logicals.get(logical));
        }
        return environment;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            if (!Os.isFamily("os/2")) {
                vmLauncher = new Java13CommandLauncher();
            }
        }
        catch (NoSuchMethodException exc) {
            // empty catch block
        }
        if (Os.isFamily("mac") && !Os.isFamily("unix")) {
            shellLauncher = new MacCommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("os/2")) {
            shellLauncher = new OS2CommandLauncher(new CommandLauncher());
        } else if (Os.isFamily("windows")) {
            environmentCaseInSensitive = true;
            CommandLauncher baseLauncher = new CommandLauncher();
            shellLauncher = !Os.isFamily("win9x") ? new WinNTCommandLauncher(baseLauncher) : new ScriptCommandLauncher("bin/antRun.bat", baseLauncher);
        } else if (Os.isFamily("netware")) {
            CommandLauncher baseLauncher = new CommandLauncher();
            shellLauncher = new PerlScriptCommandLauncher("bin/antRun.pl", baseLauncher);
        } else if (Os.isFamily("openvms")) {
            try {
                shellLauncher = new VmsCommandLauncher();
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else {
            shellLauncher = new ScriptCommandLauncher("bin/antRun", new CommandLauncher());
        }
    }

    private static class VmsCommandLauncher
    extends Java13CommandLauncher {
        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            File cmdFile = this.createCommandFile(cmd, env);
            Process p = super.exec(project, new String[]{cmdFile.getPath()}, env);
            this.deleteAfter(cmdFile, p);
            return p;
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            File cmdFile = this.createCommandFile(cmd, env);
            Process p = super.exec(project, new String[]{cmdFile.getPath()}, env, workingDir);
            this.deleteAfter(cmdFile, p);
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createCommandFile(String[] cmd, String[] env) throws IOException {
            File script = FILE_UTILS.createTempFile("ANT", ".COM", null);
            script.deleteOnExit();
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(script));
                if (env != null) {
                    for (int i = 0; i < env.length; ++i) {
                        int eqIndex = env[i].indexOf(61);
                        if (eqIndex == -1) continue;
                        out.print("$ DEFINE/NOLOG ");
                        out.print(env[i].substring(0, eqIndex));
                        out.print(" \"");
                        out.print(env[i].substring(eqIndex + 1));
                        out.println('\"');
                    }
                }
                out.print("$ " + cmd[0]);
                for (int i = 1; i < cmd.length; ++i) {
                    out.println(" -");
                    out.print(cmd[i]);
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            return script;
        }

        private void deleteAfter(final File f, final Process p) {
            new Thread(){

                public void run() {
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    FileUtils.delete(f);
                }
            }.start();
        }
    }

    private static class PerlScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        PerlScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this.myScript = script;
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (project == null) {
                if (workingDir == null) {
                    return this.exec(project, cmd, env);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String antHome = project.getProperty("ant.home");
            if (antHome == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String antRun = FILE_UTILS.resolveFile(project.getBaseDir(), antHome + File.separator + this.myScript).toString();
            File commandDir = workingDir;
            if (workingDir == null && project != null) {
                commandDir = project.getBaseDir();
            }
            String[] newcmd = new String[cmd.length + 3];
            newcmd[0] = "perl";
            newcmd[1] = antRun;
            newcmd[2] = commandDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 3, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class ScriptCommandLauncher
    extends CommandLauncherProxy {
        private String myScript;

        ScriptCommandLauncher(String script, CommandLauncher launcher) {
            super(launcher);
            this.myScript = script;
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (project == null) {
                if (workingDir == null) {
                    return this.exec(project, cmd, env);
                }
                throw new IOException("Cannot locate antRun script: No project provided");
            }
            String antHome = project.getProperty("ant.home");
            if (antHome == null) {
                throw new IOException("Cannot locate antRun script: Property 'ant.home' not found");
            }
            String antRun = FILE_UTILS.resolveFile(project.getBaseDir(), antHome + File.separator + this.myScript).toString();
            File commandDir = workingDir;
            if (workingDir == null && project != null) {
                commandDir = project.getBaseDir();
            }
            String[] newcmd = new String[cmd.length + 2];
            newcmd[0] = antRun;
            newcmd[1] = commandDir.getAbsolutePath();
            System.arraycopy(cmd, 0, newcmd, 2, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class MacCommandLauncher
    extends CommandLauncherProxy {
        MacCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            System.getProperties().put("user.dir", workingDir.getAbsolutePath());
            try {
                Process process = this.exec(project, cmd, env);
                return process;
            }
            finally {
                System.getProperties().put("user.dir", antWorkingDirectory);
            }
        }
    }

    private static class WinNTCommandLauncher
    extends CommandLauncherProxy {
        WinNTCommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            File commandDir = workingDir;
            if (workingDir == null) {
                if (project != null) {
                    commandDir = project.getBaseDir();
                } else {
                    return this.exec(project, cmd, env);
                }
            }
            int preCmdLength = 6;
            String[] newcmd = new String[cmd.length + 6];
            newcmd[0] = "cmd";
            newcmd[1] = "/c";
            newcmd[2] = "cd";
            newcmd[3] = "/d";
            newcmd[4] = commandDir.getAbsolutePath();
            newcmd[5] = "&&";
            System.arraycopy(cmd, 0, newcmd, 6, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class OS2CommandLauncher
    extends CommandLauncherProxy {
        OS2CommandLauncher(CommandLauncher launcher) {
            super(launcher);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            File commandDir = workingDir;
            if (workingDir == null) {
                if (project != null) {
                    commandDir = project.getBaseDir();
                } else {
                    return this.exec(project, cmd, env);
                }
            }
            int preCmdLength = 7;
            String cmdDir = commandDir.getAbsolutePath();
            String[] newcmd = new String[cmd.length + 7];
            newcmd[0] = "cmd";
            newcmd[1] = "/c";
            newcmd[2] = cmdDir.substring(0, 2);
            newcmd[3] = "&&";
            newcmd[4] = "cd";
            newcmd[5] = cmdDir.substring(2);
            newcmd[6] = "&&";
            System.arraycopy(cmd, 0, newcmd, 7, cmd.length);
            return this.exec(project, newcmd, env);
        }
    }

    private static class CommandLauncherProxy
    extends CommandLauncher {
        private CommandLauncher myLauncher;

        CommandLauncherProxy(CommandLauncher launcher) {
            this.myLauncher = launcher;
        }

        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            return this.myLauncher.exec(project, cmd, env);
        }
    }

    private static class Java13CommandLauncher
    extends CommandLauncher {
        private Method myExecWithCWD = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Execute.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("exec", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Execute.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Ljava$lang$String == null ? (array$Ljava$lang$String = Execute.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, class$java$io$File == null ? (class$java$io$File = Execute.class$("java.io.File")) : class$java$io$File);

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            try {
                if (project != null) {
                    project.log("Execute:Java13CommandLauncher: " + Commandline.describeCommand(cmd), 4);
                }
                return (Process)this.myExecWithCWD.invoke((Object)Runtime.getRuntime(), cmd, env, workingDir);
            }
            catch (InvocationTargetException exc) {
                Throwable realexc = exc.getTargetException();
                if (realexc instanceof ThreadDeath) {
                    throw (ThreadDeath)realexc;
                }
                if (realexc instanceof IOException) {
                    throw (IOException)realexc;
                }
                throw new BuildException("Unable to execute command", realexc);
            }
            catch (Exception exc) {
                throw new BuildException("Unable to execute command", exc);
            }
        }
    }

    private static class CommandLauncher {
        private CommandLauncher() {
        }

        public Process exec(Project project, String[] cmd, String[] env) throws IOException {
            if (project != null) {
                project.log("Execute:CommandLauncher: " + Commandline.describeCommand(cmd), 4);
            }
            return Runtime.getRuntime().exec(cmd, env);
        }

        public Process exec(Project project, String[] cmd, String[] env, File workingDir) throws IOException {
            if (workingDir == null) {
                return this.exec(project, cmd, env);
            }
            throw new IOException("Cannot execute a process in different directory under this JVM");
        }
    }
}

