/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import java.net.MalformedURLException;
import java.net.URL;

public final class MavenCoordinates {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String version;
    private final String classifier;

    public static MavenCoordinates parse(String coordinates) {
        MavenCoordinates result;
        String[] parts = coordinates.split(":");
        if (parts.length == 3) {
            result = new MavenCoordinates(parts[0], parts[1], null, parts[2], null);
        } else if (parts.length == 4) {
            result = new MavenCoordinates(parts[0], parts[1], parts[2], parts[3], null);
        } else if (parts.length == 5) {
            result = new MavenCoordinates(parts[0], parts[1], parts[2], parts[3], parts[4]);
        } else {
            throw new IllegalArgumentException("Invalid coordinates: " + coordinates);
        }
        return result;
    }

    public static MavenCoordinates create(String groupId, String artifactId, String version, String type, String classifier) {
        return new MavenCoordinates(groupId, artifactId, type, version, classifier);
    }

    private MavenCoordinates(String groupId, String artifactId, String type, String version, String classifier) {
        if (groupId == null) {
            throw new IllegalArgumentException("Null groupId");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("Null artifactId");
        }
        if (version == null) {
            throw new IllegalArgumentException("Null version");
        }
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type != null ? type : "jar";
        this.version = version;
        this.classifier = classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String toExternalForm() {
        String clstr = this.classifier != null ? ":" + this.classifier : "";
        return this.groupId + ":" + this.artifactId + ":" + this.type + ":" + this.version + clstr;
    }

    public URL getArtifactURL(URL baseURL) {
        String base = baseURL.toExternalForm();
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        String urlstr = base + this.getArtifactPath();
        try {
            return new URL(urlstr);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid artifact URL: " + urlstr);
        }
    }

    public String getArtifactPath() {
        String dirstr = this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version;
        String clstr = this.classifier != null ? "-" + this.classifier : "";
        String path = dirstr + "/" + this.artifactId + "-" + this.version + clstr + "." + this.type;
        return path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MavenCoordinates)) {
            return false;
        }
        MavenCoordinates other = (MavenCoordinates)obj;
        return this.toExternalForm().equals(other.toExternalForm());
    }

    public int hashCode() {
        return this.toExternalForm().hashCode();
    }

    public String toString() {
        return "MavenCoordinates[" + this.toExternalForm() + "]";
    }
}

