/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.utils;

import java.net.URL;
import java.util.List;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    public static String getRuntimeName(Resource resource) {
        String mvnatt;
        Capability icap = resource.getIdentityCapability();
        String runtimeName = (String)icap.getAttribute("runtime.name");
        if (runtimeName == null && (mvnatt = (String)icap.getAttribute("maven.identity")) != null) {
            MavenCoordinates mavenid = MavenCoordinates.parse(mvnatt);
            runtimeName = mavenid.getArtifactId() + "-" + mavenid.getVersion() + "." + mavenid.getType();
        }
        if (runtimeName == null) {
            List<Capability> ccaps = resource.getCapabilities("gravia.content");
            IllegalArgumentAssertion.assertFalse(ccaps.isEmpty(), "Resource has not content capability");
            URL contentURL = (URL)ccaps.get(0).getAttribute("url");
            runtimeName = contentURL != null ? contentURL.getFile() : null;
        }
        return runtimeName;
    }

    public static String getRequiredRuntimeName(Resource resource) {
        String runtimeName = ResourceUtils.getRuntimeName(resource);
        IllegalArgumentAssertion.assertTrue(runtimeName != null, "Cannot obtain runtime name for: " + resource);
        return runtimeName;
    }
}

