/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.DefaultInstallerContext;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public abstract class AbstractResourceInstaller
implements ResourceInstaller {
    public abstract RuntimeEnvironment getEnvironment();

    @Override
    public ResourceHandle installResource(ResourceInstaller.Context context, Resource res) throws ProvisionException {
        return this.installResourceInternal(context, res, this.isShared(res));
    }

    @Override
    public ResourceHandle installSharedResource(ResourceInstaller.Context context, Resource res) throws ProvisionException {
        return this.installResourceInternal(context, res, true);
    }

    private synchronized ResourceHandle installResourceInternal(ResourceInstaller.Context context, Resource resource, boolean shared) throws ProvisionException {
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        if (context == null) {
            context = new DefaultInstallerContext(resource);
        }
        try {
            return this.installResourceProtected(context, resource, shared);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ProvisionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProvisionException("Cannot provision resource: " + resource, ex);
        }
    }

    protected abstract ResourceHandle installResourceProtected(ResourceInstaller.Context var1, Resource var2, boolean var3) throws Exception;

    protected List<ContentCapability> getRelevantContentCapabilities(Resource resource) {
        ArrayList<ContentCapability> ccaps = new ArrayList<ContentCapability>();
        for (Capability cap : resource.getCapabilities("gravia.content")) {
            String includedTypes = cap.getDirective("include.runtime.type");
            String excludedTypes = cap.getDirective("exclude.runtime.type");
            if (includedTypes == null && excludedTypes == null) {
                ccaps.add((ContentCapability)cap.adapt(ContentCapability.class));
                continue;
            }
            HashSet<RuntimeType> types = new HashSet<RuntimeType>();
            if (includedTypes == null) {
                types.add(RuntimeType.getRuntimeType());
            }
            types.addAll(this.getRuntimeTypes(includedTypes));
            types.removeAll(this.getRuntimeTypes(excludedTypes));
            if (!types.contains(RuntimeType.getRuntimeType())) continue;
            ccaps.add((ContentCapability)cap.adapt(ContentCapability.class));
        }
        return ccaps;
    }

    private Set<RuntimeType> getRuntimeTypes(String directive) {
        HashSet<RuntimeType> types = new HashSet<RuntimeType>();
        if (directive != null) {
            for (String typespec : directive.split(",")) {
                types.add(RuntimeType.valueOf((String)typespec.toUpperCase()));
            }
        }
        return types;
    }

    protected ResourceContent getFirstRelevantResourceContent(Resource resource) {
        for (ContentCapability ccap : this.getRelevantContentCapabilities(resource)) {
            URL contentURL;
            InputStream contentStream = ccap.getContentStream();
            if (contentStream == null && (contentURL = ccap.getContentURL()) != null) {
                try {
                    contentStream = contentURL.openStream();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot access content URL: " + contentURL, ex);
                }
            }
            if (contentStream == null) continue;
            final InputStream inputStream = contentStream;
            return new ResourceContent(){

                public InputStream getContent() {
                    return inputStream;
                }
            };
        }
        throw new IllegalStateException("Cannot obtain content from: " + resource);
    }

    protected String getRuntimeName(Resource resource, boolean shared) {
        String runtimeName = this.getRuntimeName(resource.getIdentityCapability());
        if (runtimeName == null) {
            List<ContentCapability> ccaps = this.getRelevantContentCapabilities(resource);
            for (int i = 0; runtimeName == null && i < ccaps.size(); ++i) {
                runtimeName = this.getRuntimeName((Capability)ccaps.get(i));
            }
        }
        if (runtimeName == null) {
            ResourceIdentity resid = resource.getIdentity();
            runtimeName = shared || this.isShared(resource) ? resid.getSymbolicName() + ".jar" : (RuntimeType.TOMCAT == RuntimeType.getRuntimeType() ? resid.getSymbolicName() + ".war" : resid.getSymbolicName() + ".jar");
        }
        return runtimeName;
    }

    private String getRuntimeName(Capability cap) {
        MavenCoordinates mavenid;
        String runtimeName = (String)cap.getAttribute("runtime.name");
        if (runtimeName == null && (mavenid = (MavenCoordinates)cap.getAttribute("maven.identity")) != null) {
            runtimeName = mavenid.getArtifactId() + "-" + mavenid.getVersion() + "." + mavenid.getType();
        }
        if (runtimeName == null) {
            URL contentURL = (URL)cap.getAttribute("url");
            runtimeName = this.getRuntimeName(contentURL);
        }
        return runtimeName;
    }

    private String getRuntimeName(URL contentURL) {
        String runtimeName = null;
        if (contentURL != null) {
            String path = contentURL.getPath();
            runtimeName = path.substring(path.lastIndexOf(47) + 1);
        }
        return runtimeName;
    }

    private boolean isShared(Resource resource) {
        Object attval = resource.getIdentityCapability().getAttribute("shared");
        return Boolean.parseBoolean((String)attval);
    }
}

