/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.IllegalStateAssertion;

public class CompositePropertiesProvider
implements PropertiesProvider {
    private final PropertiesProvider[] delegates;

    public CompositePropertiesProvider(PropertiesProvider ... delegates) {
        this.delegates = delegates;
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Object getRequiredProperty(String key) {
        Object value = this.getProperty(key, null);
        IllegalStateAssertion.assertNotNull((Object)value, (String)("Cannot obtain property: " + key));
        return value;
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        Object result = null;
        for (PropertiesProvider delegate : this.delegates) {
            result = delegate.getProperty(key);
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }
}

