/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.gravia.repository.Namespace100;
import org.jboss.gravia.repository.RepositoryReader;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.spi.AttributeValueHandler;

public abstract class AbstractRepositoryXMLReader
implements RepositoryReader {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final XMLStreamReader reader;

    public AbstractRepositoryXMLReader(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Null inputStream");
        }
        this.reader = this.createXMLStreamReader(inputStream);
        try {
            this.reader.require(7, null, null);
            this.reader.nextTag();
            this.reader.require(1, "http://www.osgi.org/xmlns/repository/v1.0.0", Namespace100.Element.REPOSITORY.getLocalName());
            for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                this.attributes.put(this.reader.getAttributeLocalName(i), this.reader.getAttributeValue(i));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot read resource element: " + this.reader.getLocation(), ex);
        }
    }

    protected abstract XMLStreamReader createXMLStreamReader(InputStream var1);

    protected abstract ResourceBuilder createResourceBuilder();

    @Override
    public Map<String, String> getRepositoryAttributes() {
        return this.attributes;
    }

    @Override
    public Resource nextResource() {
        try {
            while (this.reader.hasNext() && this.reader.nextTag() != 2) {
                Namespace100.Element element = Namespace100.Element.forName(this.reader.getLocalName());
                switch (element) {
                    case RESOURCE: {
                        return this.readResourceElement(this.reader);
                    }
                }
            }
        }
        catch (XMLStreamException ex) {
            throw new IllegalStateException("Cannot read resource element: " + this.reader.getLocation(), ex);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private Resource readResourceElement(XMLStreamReader reader) throws XMLStreamException {
        ResourceBuilder builder = this.createResourceBuilder();
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace100.Element element = Namespace100.Element.forName(reader.getLocalName());
            switch (element) {
                case CAPABILITY: {
                    this.readCapabilityElement(reader, builder);
                    continue block4;
                }
                case REQUIREMENT: {
                    this.readRequirementElement(reader, builder);
                    continue block4;
                }
            }
        }
        return builder.getResource();
    }

    private void readCapabilityElement(XMLStreamReader reader, ResourceBuilder builder) throws XMLStreamException {
        String namespace = reader.getAttributeValue(null, Namespace100.Attribute.NAMESPACE.toString());
        HashMap<String, Object> atts = new HashMap<String, Object>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        this.readAttributesAndDirectives(reader, atts, dirs);
        builder.addCapability(namespace, atts, dirs);
    }

    private void readRequirementElement(XMLStreamReader reader, ResourceBuilder builder) throws XMLStreamException {
        String namespace = reader.getAttributeValue(null, Namespace100.Attribute.NAMESPACE.toString());
        HashMap<String, Object> atts = new HashMap<String, Object>();
        HashMap<String, String> dirs = new HashMap<String, String>();
        this.readAttributesAndDirectives(reader, atts, dirs);
        builder.addRequirement(namespace, atts, dirs);
    }

    private void readAttributesAndDirectives(XMLStreamReader reader, Map<String, Object> atts, Map<String, String> dirs) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace100.Element element = Namespace100.Element.forName(reader.getLocalName());
            switch (element) {
                case ATTRIBUTE: {
                    this.readAttributeElement(reader, atts);
                    continue block4;
                }
                case DIRECTIVE: {
                    this.readDirectiveElement(reader, dirs);
                    continue block4;
                }
            }
        }
    }

    private void readAttributeElement(XMLStreamReader reader, Map<String, Object> attributes) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Namespace100.Attribute.NAME.toString());
        String valstr = reader.getAttributeValue(null, Namespace100.Attribute.VALUE.toString());
        String typespec = reader.getAttributeValue(null, Namespace100.Attribute.TYPE.toString());
        AttributeValueHandler.AttributeValue value = AttributeValueHandler.readAttributeValue((String)typespec, (String)valstr);
        attributes.put(name, value.getValue());
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
    }

    private void readDirectiveElement(XMLStreamReader reader, Map<String, String> directives) throws XMLStreamException {
        String name = reader.getAttributeValue(null, Namespace100.Attribute.NAME.toString());
        String value = reader.getAttributeValue(null, Namespace100.Attribute.VALUE.toString());
        directives.put(name, value);
        while (reader.hasNext() && reader.nextTag() != 2) {
        }
    }
}

