/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.DefaultInstallerContext;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.gravia.utils.ResourceUtils;

public abstract class AbstractResourceInstaller
implements ResourceInstaller {
    public abstract RuntimeEnvironment getEnvironment();

    @Override
    public ResourceHandle installResource(ResourceInstaller.Context context, Resource resource) throws ProvisionException {
        IllegalArgumentAssertion.assertNotNull((Object)resource, (String)"resource");
        if (context == null) {
            context = new DefaultInstallerContext(resource);
        }
        try {
            return this.installResourceProtected(context, resource);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (ProvisionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ProvisionException("Cannot provision resource: " + resource, ex);
        }
    }

    protected abstract ResourceHandle installResourceProtected(ResourceInstaller.Context var1, Resource var2) throws Exception;

    protected List<ContentCapability> getRelevantContentCapabilities(Resource resource) {
        ArrayList<ContentCapability> ccaps = new ArrayList<ContentCapability>();
        for (Capability cap : resource.getCapabilities("gravia.content")) {
            String excludedTypes;
            String includedTypes = cap.getDirective("include.runtime.type");
            if (!RuntimeType.isRuntimeRelevant((String)includedTypes, (String)(excludedTypes = cap.getDirective("exclude.runtime.type")))) continue;
            ccaps.add((ContentCapability)cap.adapt(ContentCapability.class));
        }
        return ccaps;
    }

    protected ResourceContent getFirstRelevantResourceContent(Resource resource) {
        for (ContentCapability ccap : this.getRelevantContentCapabilities(resource)) {
            URL contentURL;
            InputStream contentStream = ccap.getContentStream();
            if (contentStream == null && (contentURL = ccap.getContentURL()) != null) {
                try {
                    contentStream = contentURL.openStream();
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot access content URL: " + contentURL, ex);
                }
            }
            if (contentStream == null) continue;
            final InputStream inputStream = contentStream;
            return new ResourceContent(){

                public InputStream getContent() {
                    return inputStream;
                }
            };
        }
        throw new IllegalStateException("Cannot obtain content from: " + resource);
    }

    protected String getRuntimeName(Resource resource) {
        List<ContentCapability> ccaps;
        Capability icap = resource.getIdentityCapability();
        String runtimeName = (String)icap.getAttribute("runtime.name");
        if (runtimeName == null && (ccaps = this.getRelevantContentCapabilities(resource)).size() == 1) {
            ContentCapability ccap = ccaps.get(0);
            runtimeName = (String)ccap.getAttribute("runtime.name");
        }
        if (runtimeName == null) {
            ResourceIdentity resid = resource.getIdentity();
            String qualifiedName = resid.getSymbolicName() + "-" + resid.getVersion();
            runtimeName = ResourceUtils.isShared((Resource)resource) ? qualifiedName + ".jar" : (RuntimeType.TOMCAT == RuntimeType.getRuntimeType() ? qualifiedName + ".war" : qualifiedName + ".jar");
        }
        return runtimeName;
    }
}

