/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.support;

import java.io.File;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.jboss.gravia.container.tomcat.support.SecurityActions;
import org.jboss.gravia.runtime.spi.DefaultPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.NotNullException;

public class TomcatPropertiesProvider
implements PropertiesProvider {
    private static final File catalinaHome = new File(SecurityActions.getSystemProperty("catalina.home", null));
    private static final File catalinaWork = new File(catalinaHome.getPath() + File.separator + "work");
    private final ServletContext servletContext;
    private PropertiesProvider delegate;

    public TomcatPropertiesProvider(ServletContext servletContext) {
        NotNullException.assertValue((Object)servletContext, (String)"servletContext");
        this.servletContext = servletContext;
    }

    public File getCatalinaHome() {
        return catalinaHome;
    }

    public File getCatalinaWork() {
        return catalinaWork;
    }

    public Object getProperty(String key) {
        return this.getInternalPropertiesProvider().getProperty(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        return this.getInternalPropertiesProvider().getProperty(key, defaultValue);
    }

    private synchronized PropertiesProvider getInternalPropertiesProvider() {
        if (this.delegate == null) {
            Properties properties = this.initialProperties(this.servletContext);
            this.delegate = new DefaultPropertiesProvider(properties, true);
        }
        return this.delegate;
    }

    protected Properties initialProperties(ServletContext servletContext) {
        Properties properties = new Properties();
        properties.setProperty("org.jboss.gravia.runtime.type", "tomcat");
        String storageClean = servletContext.getInitParameter("org.jboss.gravia.runtime.storage.clean");
        if (storageClean == null) {
            storageClean = "onFirstInit";
        }
        properties.setProperty("org.jboss.gravia.runtime.storage.clean", storageClean);
        String storageDir = servletContext.getInitParameter("org.jboss.gravia.runtime.storage");
        if (storageDir == null) {
            storageDir = new File(catalinaWork.getPath() + File.separator + "gravia-store").getAbsolutePath();
        }
        properties.setProperty("org.jboss.gravia.runtime.storage", storageDir);
        storageDir = servletContext.getInitParameter("org.jboss.gravia.repository.storage.dir");
        if (storageDir == null) {
            storageDir = new File(catalinaWork.getPath() + File.separator + "repository").getAbsolutePath();
        }
        properties.setProperty("org.jboss.gravia.repository.storage.dir", storageDir);
        return properties;
    }
}

