/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.ant.DeployTask;
import org.apache.catalina.ant.UndeployTask;
import org.apache.catalina.users.MemoryUserDatabase;
import org.jboss.gravia.container.tomcat.extension.SharedModuleClassLoader;
import org.jboss.gravia.container.tomcat.support.GraviaTomcatLogger;
import org.jboss.gravia.container.tomcat.support.SecurityActions;
import org.jboss.gravia.provision.DefaultResourceHandle;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.spi.AbstractResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.ContentCapability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.NamedResourceAssociation;
import org.jboss.gravia.utils.IOUtils;

public class TomcatResourceInstaller
extends AbstractResourceInstaller {
    private static final File catalinaHome = new File(SecurityActions.getSystemProperty("catalina.home", null));
    private static final File catalinaLib = new File(catalinaHome.getPath() + File.separator + "lib");
    private static final File catalinaTemp = new File(catalinaHome.getPath() + File.separator + "temp");
    private static final String TOMCAT_USER = "tomcat";
    private final UserDatabase userDatabase;
    private final RuntimeEnvironment environment;

    public TomcatResourceInstaller(RuntimeEnvironment environment) {
        this.environment = environment;
        try {
            this.userDatabase = new MemoryUserDatabase();
            this.userDatabase.open();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot open user database", ex);
        }
        if (this.userDatabase.findUser(TOMCAT_USER) == null) {
            throw new IllegalStateException("Cannot obtain user: tomcat");
        }
    }

    public RuntimeEnvironment getEnvironment() {
        return this.environment;
    }

    public ResourceHandle installSharedResource(Resource resource, Map<Requirement, Resource> mapping) throws Exception {
        GraviaTomcatLogger.LOGGER.info("Installing shared resource: {}", (Object)resource);
        ResourceIdentity resid = resource.getIdentity();
        ResourceContent content = (ResourceContent)resource.adapt(ResourceContent.class);
        if (content == null) {
            throw new IllegalStateException("Cannot obtain content from: " + resource);
        }
        File targetFile = new File(catalinaLib, resid.getSymbolicName() + "-" + resid.getVersion() + ".jar");
        if (targetFile.exists()) {
            throw new IllegalStateException("Module already exists: " + targetFile);
        }
        IOUtils.copyStream((InputStream)content.getContent(), (OutputStream)new FileOutputStream(targetFile));
        Module module = this.installSharedResource(resource, targetFile);
        Resource modres = (Resource)module.adapt(Resource.class);
        return new DefaultResourceHandle(modres, module){

            public void uninstall() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle installUnsharedResource(Resource resource, Map<Requirement, Resource> mapping) throws Exception {
        GraviaTomcatLogger.LOGGER.info("Installing unshared resource: {}", (Object)resource);
        File tempfile = null;
        ResourceIdentity identity = resource.getIdentity();
        ContentCapability ccap = (ContentCapability)resource.getCapabilities("gravia.content").get(0);
        URL contentURL = ccap.getContentURL();
        if (contentURL == null) {
            InputStream content = ((ResourceContent)resource.adapt(ResourceContent.class)).getContent();
            tempfile = new File(catalinaTemp, identity.getSymbolicName() + "-" + identity.getVersion() + ".war");
            IOUtils.copyStream((InputStream)content, (OutputStream)new FileOutputStream(tempfile));
            contentURL = tempfile.toURI().toURL();
        }
        final String contextPath = this.getContextPath(resource);
        final User user = this.userDatabase.findUser(TOMCAT_USER);
        final String password = user.getPassword();
        NamedResourceAssociation.putResource((String)contextPath, (Resource)resource);
        try {
            DeployTask task = new DeployTask();
            task.setWar(contentURL.toExternalForm());
            task.setUsername(user.getName());
            task.setPassword(password);
            task.setPath(contextPath);
            task.execute();
        }
        finally {
            NamedResourceAssociation.removeResource((String)contextPath);
            if (tempfile != null) {
                tempfile.delete();
            }
        }
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(identity);
        return new DefaultResourceHandle(resource, module){

            public void uninstall() {
                UndeployTask task = new UndeployTask();
                task.setUsername(user.getName());
                task.setPassword(password);
                task.setPath(contextPath);
                task.execute();
            }
        };
    }

    private Module installSharedResource(Resource resource, File targetFile) throws Exception {
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        for (Capability cap : resource.getCapabilities(null)) {
            String namespace = cap.getNamespace();
            if ("gravia.content".equals(namespace)) continue;
            builder.addCapability(namespace, cap.getAttributes(), cap.getDirectives());
        }
        builder.addContentCapability(targetFile.toURI().toURL());
        for (Requirement req : resource.getRequirements(null)) {
            builder.addRequirement(req.getNamespace(), req.getAttributes(), req.getDirectives());
        }
        resource = builder.getResource();
        SharedModuleClassLoader.addSharedModule((Resource)resource);
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ClassLoader classLoader = SharedModuleClassLoader.class.getClassLoader();
        return runtime.installModule(classLoader, resource, null);
    }

    private String getContextPath(Resource res) {
        String contextPath = (String)res.getIdentityCapability().getAttribute("contextPath");
        if (contextPath == null) {
            contextPath = res.getIdentity().getSymbolicName();
        }
        return "/" + contextPath;
    }
}

