/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.support;

import java.io.File;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.jboss.gravia.container.tomcat.support.SecurityActions;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.spi.AbstractPropertiesProvider;
import org.jboss.gravia.runtime.spi.DefaultPropertiesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.utils.IllegalArgumentAssertion;

public class ServletContextPropertiesProvider
extends AbstractPropertiesProvider {
    private static final File catalinaHome = new File(SecurityActions.getSystemProperty("catalina.home", null));
    private static final File catalinaConf = new File(catalinaHome, "conf");
    private static final File catalinaWork = new File(catalinaHome, "work");
    private final ServletContext servletContext;
    private PropertiesProvider delegate;

    public ServletContextPropertiesProvider(ServletContext servletContext) {
        IllegalArgumentAssertion.assertNotNull((Object)servletContext, (String)"servletContext");
        this.servletContext = servletContext;
    }

    public Object getProperty(String key, Object defaultValue) {
        return this.getInternalPropertiesProvider().getProperty(key, defaultValue);
    }

    private synchronized PropertiesProvider getInternalPropertiesProvider() {
        if (this.delegate == null) {
            Properties properties = this.initialProperties(this.servletContext);
            this.delegate = new DefaultPropertiesProvider(properties, true);
        }
        return this.delegate;
    }

    protected Properties initialProperties(ServletContext servletContext) {
        Properties properties = new Properties();
        properties.setProperty("org.jboss.gravia.runtime.type", RuntimeType.TOMCAT.toString());
        String storageDir = servletContext.getInitParameter("org.jboss.gravia.runtime.storage.dir");
        if (storageDir == null) {
            storageDir = new File(catalinaWork, "gravia-store").getAbsolutePath();
        }
        properties.setProperty("org.jboss.gravia.runtime.storage.dir", storageDir);
        String repositoryDir = servletContext.getInitParameter("org.jboss.gravia.repository.storage.dir");
        if (repositoryDir == null) {
            repositoryDir = new File(catalinaWork, "repository").getAbsolutePath();
        }
        properties.setProperty("org.jboss.gravia.repository.storage.dir", repositoryDir);
        String configsDir = servletContext.getInitParameter("org.jboss.gravia.runtime.configurations.dir");
        if (configsDir == null) {
            configsDir = new File(catalinaConf, "gravia" + File.separator + "configs").getAbsolutePath();
        }
        properties.setProperty("org.jboss.gravia.runtime.configurations.dir", configsDir);
        return properties;
    }
}

