/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.tomcat.webapp;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.gravia.container.common.ActivationSupport;
import org.jboss.gravia.container.tomcat.support.TomcatPropertiesProvider;
import org.jboss.gravia.container.tomcat.support.TomcatResourceInstaller;
import org.jboss.gravia.container.tomcat.support.TomcatRuntimeFactory;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.WebAppContextListener;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;

@WebListener
public class GraviaTomcatActivator
implements ServletContextListener {
    private Set<ServiceRegistration<?>> registrations = new HashSet();

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        TomcatPropertiesProvider propsProvider = new TomcatPropertiesProvider(servletContext);
        Runtime runtime = RuntimeLocator.createRuntime((RuntimeFactory)new TomcatRuntimeFactory(servletContext), (PropertiesProvider)propsProvider);
        runtime.init();
        Object configsDir = propsProvider.getProperty("org.jboss.gravia.configurations.dir");
        ActivationSupport.initConfigurationAdmin((File)new File((String)configsDir));
        this.registerServices(servletContext, runtime);
        WebAppContextListener webappInstaller = new WebAppContextListener();
        Module module = webappInstaller.installWebappModule(servletContext);
        servletContext.setAttribute(Module.class.getName(), (Object)module);
        try {
            module.start();
        }
        catch (ModuleException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void registerServices(ServletContext servletContext, Runtime runtime) {
        RuntimeEnvironment environment = new RuntimeEnvironment(runtime).initDefaultContent();
        TomcatResourceInstaller installer = new TomcatResourceInstaller(environment);
        ModuleContext syscontext = runtime.getModuleContext();
        this.registrations.add(syscontext.registerService(RuntimeEnvironment.class, (Object)environment, null));
        this.registrations.add(syscontext.registerService(ResourceInstaller.class, (Object)installer, null));
    }

    public void contextDestroyed(ServletContextEvent event) {
        for (ServiceRegistration sreg : this.registrations) {
            sreg.unregister();
        }
    }
}

