/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.spi;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeEventsManager;
import org.jboss.gravia.runtime.spi.RuntimeLogger;

public abstract class AbstractRuntime
implements Runtime {
    private final Map<Long, Module> modules = new ConcurrentHashMap<Long, Module>();
    private final RuntimeEventsManager runtimeEvents = new RuntimeEventsManager();
    private final PropertiesProvider properties;

    protected AbstractRuntime(PropertiesProvider propertiesProvider) {
        this.properties = propertiesProvider;
    }

    public abstract AbstractModule createModule(ClassLoader var1, Resource var2, Dictionary<String, String> var3);

    public abstract ModuleEntriesProvider getModuleEntriesProvider(Module var1);

    @Override
    public final Object getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public final Object getProperty(String key, Object defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public <A> A adapt(Class<A> type) {
        Object result = null;
        if (type.isAssignableFrom(RuntimeEventsManager.class)) {
            result = this.runtimeEvents;
        } else if (type.isAssignableFrom(ModuleContext.class)) {
            result = this.getModule(0L).getModuleContext();
        }
        return (A)result;
    }

    @Override
    public final Module getModule(long id) {
        return this.modules.get(id);
    }

    @Override
    public final Module getModule(ResourceIdentity identity) {
        for (Module module : this.modules.values()) {
            if (!module.getIdentity().equals((Object)identity)) continue;
            return module;
        }
        return null;
    }

    @Override
    public final Module getModule(ClassLoader classLoader) {
        Set<Module> modules = this.getModules(classLoader);
        return modules.size() > 0 ? modules.iterator().next() : null;
    }

    @Override
    public final Set<Module> getModules() {
        return new HashSet<Module>(this.modules.values());
    }

    @Override
    public final Set<Module> getModules(ClassLoader classLoader) {
        Set<Module> result = this.getModules();
        Iterator<Module> iterator = result.iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            if (module.adapt(ClassLoader.class).equals(classLoader)) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public Set<Module> getModules(String symbolicName, VersionRange range) {
        Set<Module> result = this.getModules();
        Iterator<Module> iterator = result.iterator();
        while (iterator.hasNext()) {
            ResourceIdentity modid = iterator.next().getIdentity();
            if (symbolicName != null && !symbolicName.equals(modid.getSymbolicName())) {
                iterator.remove();
            }
            if (range == null || range.includes(modid.getVersion())) continue;
            iterator.remove();
        }
        return result;
    }

    @Override
    public final Module installModule(ClassLoader classLoader, Dictionary<String, String> headers) throws ModuleException {
        return this.installModule(classLoader, null, headers);
    }

    @Override
    public final Module installModule(ClassLoader classLoader, Resource resource, Dictionary<String, String> headers) throws ModuleException {
        AbstractModule module = this.createModule(classLoader, resource, headers);
        if (this.getModule(module.getIdentity()) != null) {
            throw new ModuleException("ModuleAlready installed: " + module);
        }
        this.modules.put(module.getModuleId(), module);
        module.setState(Module.State.INSTALLED);
        this.runtimeEvents.fireModuleEvent(module, 1);
        module.setState(Module.State.RESOLVED);
        this.runtimeEvents.fireModuleEvent(module, 32);
        RuntimeLogger.LOGGER.info("Installed: {}", (Object)module);
        return module;
    }

    protected void uninstallModule(Module module) {
        this.modules.remove(module.getModuleId());
        RuntimeLogger.LOGGER.info("Uninstalled: {}", (Object)module);
    }
}

