/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.provision.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.gravia.provision.Environment;
import org.jboss.gravia.provision.ProvisionException;
import org.jboss.gravia.provision.ProvisionResult;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.DefaultResolveContext;
import org.jboss.gravia.resolver.PreferencePolicy;
import org.jboss.gravia.resolver.ResolutionException;
import org.jboss.gravia.resolver.ResolveContext;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceStore;
import org.jboss.gravia.resource.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProvisioner
implements Provisioner {
    static final Logger LOGGER = LoggerFactory.getLogger((String)Provisioner.class.getPackage().getName());
    private final Resolver resolver;
    private final Repository repository;
    private PreferencePolicy preferencePolicy;
    private Environment environment;

    public AbstractProvisioner(Resolver resolver, Repository repository) {
        this.resolver = resolver;
        this.repository = repository;
    }

    protected abstract Environment createEnvironment();

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        return this.environment;
    }

    protected abstract Environment cloneEnvironment(Environment var1);

    @Override
    public final Resolver getResolver() {
        return this.resolver;
    }

    @Override
    public final Repository getRepository() {
        return this.repository;
    }

    protected abstract PreferencePolicy createPreferencePolicy();

    private PreferencePolicy getPreferencePolicyInternal() {
        if (this.preferencePolicy == null) {
            this.preferencePolicy = this.createPreferencePolicy();
        }
        return this.preferencePolicy;
    }

    @Override
    public ProvisionResult findResources(Set<Requirement> reqs) {
        return this.findResources(this.getEnvironment(), reqs);
    }

    @Override
    public final ProvisionResult findResources(Environment env, Set<Requirement> reqs) {
        if (env == null) {
            throw new IllegalArgumentException("Null env");
        }
        if (reqs == null) {
            throw new IllegalArgumentException("Null reqs");
        }
        LOGGER.debug("START findResources: {}", reqs);
        ArrayList<Resource> unresolved = new ArrayList<Resource>();
        Environment envclone = this.cloneEnvironment(env);
        for (Requirement req : reqs) {
            Resource res = req.getResource();
            if (env.getResource(res.getIdentity()) != null) continue;
            envclone.addResource(res);
            unresolved.add(res);
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        HashSet<Requirement> unstatisfied = new HashSet<Requirement>(reqs);
        HashMap<Requirement, Resource> mapping = new HashMap<Requirement, Resource>();
        this.findResources(envclone, unresolved, mapping, unstatisfied, resources);
        Iterator itres = resources.iterator();
        while (itres.hasNext()) {
            Resource res = (Resource)itres.next();
            if (!this.isAbstract(res)) continue;
            itres.remove();
        }
        ArrayList<Resource> sorted = new ArrayList<Resource>();
        for (Resource res : resources) {
            this.sortResultResources(res, mapping, sorted);
        }
        AbstractProvisionResult result = new AbstractProvisionResult(mapping, unstatisfied, sorted);
        LOGGER.debug("END findResources");
        LOGGER.debug("  resources: {}", result.getResources());
        LOGGER.debug("  unsatisfied: {}", result.getUnsatisfiedRequirements());
        LinkedHashSet<Resource> mandatory = new LinkedHashSet<Resource>();
        mandatory.addAll(result.getResources());
        try {
            DefaultResolveContext context = new DefaultResolveContext((ResourceStore)envclone, mandatory, null);
            this.resolver.resolve((ResolveContext)context).entrySet();
        }
        catch (ResolutionException ex) {
            LOGGER.warn("Cannot resolve provisioner result", (Throwable)ex);
        }
        return result;
    }

    private void sortResultResources(Resource res, Map<Requirement, Resource> mapping, List<Resource> result) {
        if (!result.contains(res)) {
            for (Requirement req : res.getRequirements(null)) {
                Resource target = mapping.get(req);
                if (target == null) continue;
                this.sortResultResources(target, mapping, result);
            }
            result.add(res);
        }
    }

    @Override
    public Provisioner.ResourceHandle installResource(Resource resource, Map<Requirement, Resource> mapping) throws ProvisionException {
        throw new UnsupportedOperationException();
    }

    private boolean isAbstract(Resource res) {
        Object attval = res.getIdentityCapability().getAttribute("type");
        return "abstract".equals(attval);
    }

    private void findResources(Environment env, List<Resource> unresolved, Map<Requirement, Resource> mapping, Set<Requirement> unstatisfied, List<Resource> resources) {
        this.resolveInEnvironment(env, unresolved, mapping, unstatisfied, resources);
        if (unstatisfied.isEmpty()) {
            return;
        }
        boolean envModified = false;
        HashSet<Resource> installable = new HashSet<Resource>();
        LOGGER.debug("Finding unsatisfied reqs");
        for (Requirement req : unstatisfied) {
            Capability cap;
            if (!env.findProviders(req).isEmpty() || (cap = this.findProviderInRepository(req)) == null) continue;
            installable.add(cap.getResource());
        }
        for (Resource res : installable) {
            if (resources.contains(res)) continue;
            List reqs = res.getRequirements(null);
            LOGGER.debug("Adding %d unsatisfied reqs", (Object)reqs.size());
            unstatisfied.addAll(reqs);
            env.addResource(res);
            resources.add(res);
            envModified = true;
        }
        if (envModified) {
            this.findResources(env, unresolved, mapping, unstatisfied, resources);
        }
    }

    private Capability findProviderInRepository(Requirement req) {
        LOGGER.debug("Find in repository: {}", (Object)req);
        ArrayList providers = this.repository.findProviders(req);
        if (providers.size() > 1) {
            providers = new ArrayList(providers);
            Iterator itcap = providers.iterator();
            while (itcap.hasNext()) {
                Capability cap = (Capability)itcap.next();
                if (!this.isAbstract(cap.getResource())) continue;
                itcap.remove();
            }
        }
        Capability cap = null;
        if (providers.size() == 1) {
            cap = (Capability)providers.iterator().next();
            LOGGER.debug(" Found one: {}", (Object)cap);
        } else if (providers.size() > 1) {
            ArrayList sorted = new ArrayList(providers);
            this.getPreferencePolicyInternal().sort(sorted);
            LOGGER.debug(" Found multiple: {}", sorted);
            cap = (Capability)sorted.get(0);
        } else {
            LOGGER.debug(" Not found: {}", (Object)req);
        }
        return cap;
    }

    private void resolveInEnvironment(Environment env, List<Resource> unresolved, Map<Requirement, Resource> mapping, Set<Requirement> unstatisfied, List<Resource> resources) {
        LinkedHashSet<Resource> mandatory = new LinkedHashSet<Resource>();
        mandatory.addAll(unresolved);
        mandatory.addAll(resources);
        try {
            DefaultResolveContext context = new DefaultResolveContext((ResourceStore)env, mandatory, null);
            Set wiremap = this.resolver.resolve((ResolveContext)context).entrySet();
            for (Map.Entry entry : wiremap) {
                for (Wire wire : (List)entry.getValue()) {
                    Requirement req = wire.getRequirement();
                    Resource provider = wire.getProvider();
                    mapping.put(req, provider);
                }
            }
            unstatisfied.clear();
        }
        catch (ResolutionException ex) {
            for (Requirement req : ex.getUnresolvedRequirements()) {
                LOGGER.debug(" unresolved: {}", (Object)req);
            }
        }
    }

    static class AbstractProvisionResult
    implements ProvisionResult {
        private final Map<Requirement, Resource> mapping;
        private final Set<Requirement> unsatisfied;
        private final List<Resource> resources;

        public AbstractProvisionResult(Map<Requirement, Resource> mapping, Set<Requirement> unstatisfied, List<Resource> resources) {
            this.mapping = mapping;
            this.unsatisfied = unstatisfied;
            this.resources = resources;
        }

        @Override
        public Map<Requirement, Resource> getMapping() {
            return Collections.unmodifiableMap(this.mapping);
        }

        @Override
        public List<Resource> getResources() {
            return Collections.unmodifiableList(this.resources);
        }

        @Override
        public Set<Requirement> getUnsatisfiedRequirements() {
            return Collections.unmodifiableSet(this.unsatisfied);
        }
    }
}

