/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.embedded.osgi.BundleContextAdaptor;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.CaseInsensitiveDictionary;
import org.jboss.gravia.utils.NotNullException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class BundleAdaptor
implements Bundle {
    private final Module module;

    public BundleAdaptor(Module module) {
        NotNullException.assertValue((Object)module, (String)"module");
        this.module = module;
    }

    public long getBundleId() {
        return this.module.getModuleId();
    }

    public String getSymbolicName() {
        return this.module.getIdentity().getSymbolicName();
    }

    public Version getVersion() {
        String version = this.module.getIdentity().getVersion().toString();
        return Version.parseVersion((String)version);
    }

    public String getLocation() {
        return this.module.getIdentity().toString();
    }

    public int getState() {
        switch (this.module.getState()) {
            case INSTALLED: {
                return 2;
            }
            case RESOLVED: {
                return 4;
            }
            case STARTING: {
                return 8;
            }
            case ACTIVE: {
                return 32;
            }
            case STOPPING: {
                return 16;
            }
            case UNINSTALLED: {
                return 1;
            }
        }
        return 1;
    }

    public BundleContext getBundleContext() {
        ModuleContext context = this.module.getModuleContext();
        return context != null ? new BundleContextAdaptor(context) : null;
    }

    public <A> A adapt(Class<A> type) {
        return (A)this.module.adapt(type);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.module.loadClass(className);
    }

    public URL getResource(String name) {
        ClassLoader classLoader = (ClassLoader)this.module.adapt(ClassLoader.class);
        return classLoader.getResource(name);
    }

    public Dictionary<String, String> getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary<String, String> getHeaders(String locale) {
        Dictionary rawHeaders = this.module.getHeaders();
        if ("".equals(locale)) {
            return rawHeaders;
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        Enumeration e = rawHeaders.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)rawHeaders.get(key);
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            ((Dictionary)result).put(key, value);
        }
        return new CaseInsensitiveDictionary(result);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader classLoader = (ClassLoader)this.module.adapt(ClassLoader.class);
        return classLoader.getResources(name);
    }

    public URL getEntry(String path) {
        ModuleEntriesProvider entriesProvider = (ModuleEntriesProvider)this.module.adapt(ModuleEntriesProvider.class);
        return entriesProvider != null ? entriesProvider.getEntry(path) : null;
    }

    public Enumeration<String> getEntryPaths(String path) {
        ModuleEntriesProvider entriesProvider = (ModuleEntriesProvider)this.module.adapt(ModuleEntriesProvider.class);
        return entriesProvider != null ? entriesProvider.getEntryPaths(path) : null;
    }

    public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
        ModuleEntriesProvider entriesProvider = (ModuleEntriesProvider)this.module.adapt(ModuleEntriesProvider.class);
        return entriesProvider != null ? entriesProvider.findEntries(path, filePattern, recurse) : null;
    }

    public int compareTo(Bundle bundle) {
        throw new UnsupportedOperationException("Bundle.compareTo(Bundle)");
    }

    public void start(int options) throws BundleException {
        throw new UnsupportedOperationException("Bundle.start(int)");
    }

    public void start() throws BundleException {
        throw new UnsupportedOperationException("Bundle.start()");
    }

    public void stop(int options) throws BundleException {
        throw new UnsupportedOperationException("Bundle.stop(int)");
    }

    public void stop() throws BundleException {
        throw new UnsupportedOperationException("Bundle.stop()");
    }

    public void update(InputStream input) throws BundleException {
        throw new UnsupportedOperationException("Bundle.update(InputStream)");
    }

    public void update() throws BundleException {
        throw new UnsupportedOperationException("Bundle.update()");
    }

    public void uninstall() throws BundleException {
        throw new UnsupportedOperationException("Bundle.uninstall()");
    }

    public ServiceReference<?>[] getRegisteredServices() {
        throw new UnsupportedOperationException("Bundle.getRegisteredServices()");
    }

    public ServiceReference<?>[] getServicesInUse() {
        throw new UnsupportedOperationException("Bundle.getServicesInUse()");
    }

    public long getLastModified() {
        throw new UnsupportedOperationException("Bundle.getLastModified()");
    }

    public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
        throw new UnsupportedOperationException("Bundle.getSignerCertificates(int)");
    }

    public File getDataFile(String filename) {
        return this.module.getDataFile(filename);
    }

    public boolean hasPermission(Object permission) {
        throw new UnsupportedOperationException("Bundle.hasPermission(Object)");
    }

    public String toString() {
        return "Bundle[" + this.module.getIdentity() + "]";
    }
}

