/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.osgi;

import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ServiceFactory;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedLogServiceFactory
implements ServiceFactory<LogService> {
    public LogService getService(Module module, ServiceRegistration<LogService> registration) {
        return new EmbeddedLogService(module);
    }

    public void ungetService(Module module, ServiceRegistration<LogService> registration, LogService service) {
    }

    static class EmbeddedLogService
    implements LogService {
        private final Logger LOGGER;

        EmbeddedLogService(Module module) {
            this.LOGGER = LoggerFactory.getLogger((String)module.getIdentity().toString());
        }

        public void log(int level, String message) {
            this.logInternal(level, message, null, null);
        }

        public void log(int level, String message, Throwable cause) {
            this.logInternal(level, message, cause, null);
        }

        public void log(ServiceReference sref, int level, String message) {
            this.logInternal(level, message, null, sref);
        }

        public void log(ServiceReference sref, int level, String message, Throwable cause) {
            this.logInternal(level, message, cause, sref);
        }

        private void logInternal(int level, String message, Throwable cause, Object sref) {
            if (sref != null) {
                message = "[" + sref + "] " + message;
            }
            switch (level) {
                case 4: {
                    this.LOGGER.debug(message, cause);
                    break;
                }
                case 3: {
                    this.LOGGER.info(message, cause);
                    break;
                }
                case 2: {
                    this.LOGGER.warn(message, cause);
                    break;
                }
                case 1: {
                    this.LOGGER.error(message, cause);
                }
            }
        }
    }
}

