/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.service.command.Descriptor;

class ScrGogoCommand {
    private final ScrCommand scrCommand;

    public ScrGogoCommand(ScrCommand scrCommand) {
        this.scrCommand = scrCommand;
    }

    @Descriptor(value="List all components")
    public void list() {
        this.scrCommand.list(null, System.out, System.err);
    }

    @Descriptor(value="List components of a specific bundle")
    public void list(@Descriptor(value="Symbolic name or ID of the bundle") String bundleIdentifier) {
        this.scrCommand.list(bundleIdentifier, System.out, System.err);
    }

    @Descriptor(value="Dump information of a component")
    public void info(@Descriptor(value="Name or ID of the component") String componentIdentifier) {
        this.scrCommand.info(componentIdentifier, System.out, System.err);
    }

    @Descriptor(value="Enable a disabled component")
    public void enable(@Descriptor(value="Name or ID of the component") String componentIdentifier) {
        this.scrCommand.change(componentIdentifier, System.out, System.err, true);
    }

    @Descriptor(value="Disable an enabled component")
    public void disable(@Descriptor(value="Name or ID of the component") String componentIdentifier) {
        this.scrCommand.change(componentIdentifier, System.out, System.err, false);
    }

    @Descriptor(value="Show the current SCR configuration")
    public void config() {
        this.scrCommand.config(System.out);
    }
}

