/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.deployment;

import java.util.Dictionary;
import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.gravia.resource.Attachable;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.spi.AttachableSupport;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.ManifestHeadersProvider;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.gravia.service.WildflyRuntime;

public class ModuleInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Manifest manifest;
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Resource resource = (Resource)depUnit.getAttachment(GraviaConstants.RESOURCE_KEY);
        if (resource == null) {
            return;
        }
        Dictionary headers = null;
        ResourceRoot deploymentRoot = (ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        Manifest manifest2 = manifest = deploymentRoot != null ? (Manifest)deploymentRoot.getAttachment(Attachments.MANIFEST) : null;
        if (manifest != null) {
            headers = new ManifestHeadersProvider(manifest).getHeaders();
        }
        AttachableSupport context = new AttachableSupport();
        context.putAttachment(WildflyRuntime.DEPLOYMENT_ROOT_KEY, (Object)deploymentRoot);
        ModuleClassLoader classLoader = ((Module)depUnit.getAttachment(Attachments.MODULE)).getClassLoader();
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            org.jboss.gravia.runtime.Module module = runtime.installModule((ClassLoader)classLoader, resource, headers, (Attachable)context);
            depUnit.putAttachment(GraviaConstants.MODULE_KEY, (Object)module);
            depUnit.putAttachment(GraviaConstants.RESOURCE_KEY, module.adapt(Resource.class));
        }
        catch (ModuleException ex) {
            throw new DeploymentUnitProcessingException((Throwable)ex);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        org.jboss.gravia.runtime.Module module = (org.jboss.gravia.runtime.Module)depUnit.getAttachment(GraviaConstants.MODULE_KEY);
        if (module != null && module.getState() != Module.State.UNINSTALLED) {
            module.uninstall();
        }
    }
}

