/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.proxy;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.proxy.DispatcherTracker;
import org.osgi.framework.BundleContext;

public final class ProxyServlet
extends HttpServlet {
    private DispatcherTracker tracker;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            this.doInit();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void doInit() throws Exception {
        this.tracker = new DispatcherTracker(this.getBundleContext(), null, this.getServletConfig());
        this.tracker.open();
    }

    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpServlet dispatcher = this.tracker.getDispatcher();
        if (dispatcher != null) {
            dispatcher.service((ServletRequest)req, (ServletResponse)res);
        } else {
            res.sendError(503);
        }
    }

    public void destroy() {
        this.tracker.close();
        super.destroy();
    }

    private BundleContext getBundleContext() throws ServletException {
        Object context = this.getServletContext().getAttribute(BundleContext.class.getName());
        if (context instanceof BundleContext) {
            return (BundleContext)context;
        }
        throw new ServletException("Bundle context attribute [" + BundleContext.class.getName() + "] not set in servlet context");
    }
}

