/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.internal;

import java.io.File;
import org.jboss.gravia.repository.DefaultRepository;
import org.jboss.gravia.repository.RepositoryRuntimeRegistration;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.util.RuntimePropertiesProvider;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public final class RepositoryActivator
implements BundleActivator {
    private RepositoryRuntimeRegistration.Registration registration;

    public void start(final BundleContext context) throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        RuntimePropertiesProvider propertyProvider = new RuntimePropertiesProvider(runtime){

            public Object getProperty(String key, Object defaultValue) {
                Object value = super.getProperty(key, defaultValue);
                if (value == null && "org.jboss.gravia.repository.storage.dir".equals(key)) {
                    File dirname = context.getBundle().getDataFile("repository");
                    value = dirname.getAbsolutePath();
                }
                return value != null ? (String)value : null;
            }
        };
        DefaultRepository repository = new DefaultRepository((PropertiesProvider)propertyProvider);
        this.registration = RepositoryRuntimeRegistration.registerRepository(runtime, repository);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

