/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.provision.DefaultProvisioner;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extension.gravia.GraviaConstants;

public class ProvisionerService
extends AbstractService<Provisioner> {
    static final Logger LOGGER = LoggerFactory.getLogger((String)GraviaConstants.class.getPackage().getName());
    private final InjectedValue<ModuleContext> injectedModuleContext = new InjectedValue();
    private final InjectedValue<Environment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<Repository> injectedRepository = new InjectedValue();
    private final InjectedValue<Resolver> injectedResolver = new InjectedValue();
    private final InjectedValue<ResourceInstaller> injectedInstaller = new InjectedValue();
    private ServiceRegistration<Provisioner> registration;
    private Provisioner provisioner;

    public ServiceController<Provisioner> install(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.PROVISIONER_SERVICE_NAME, (Service)this);
        builder.addDependency(GraviaConstants.ENVIRONMENT_SERVICE_NAME, Environment.class, this.injectedEnvironment);
        builder.addDependency(GraviaConstants.MODULE_CONTEXT_SERVICE_NAME, ModuleContext.class, this.injectedModuleContext);
        builder.addDependency(GraviaConstants.REPOSITORY_SERVICE_NAME, Repository.class, this.injectedRepository);
        builder.addDependency(GraviaConstants.RESOLVER_SERVICE_NAME, Resolver.class, this.injectedResolver);
        builder.addDependency(GraviaConstants.RESOURCE_INSTALLER_SERVICE_NAME, ResourceInstaller.class, this.injectedInstaller);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        Resolver resolver = (Resolver)this.injectedResolver.getValue();
        Repository repository = (Repository)this.injectedRepository.getValue();
        Environment environment = (Environment)this.injectedEnvironment.getValue();
        ResourceInstaller installer = (ResourceInstaller)this.injectedInstaller.getValue();
        this.provisioner = new DefaultProvisioner(environment, resolver, repository, installer);
        ModuleContext syscontext = (ModuleContext)this.injectedModuleContext.getValue();
        this.registration = syscontext.registerService(Provisioner.class, (Object)this.provisioner, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public Provisioner getValue() throws IllegalStateException {
        return this.provisioner;
    }
}

