/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentHelper;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.gravia.provision.DefaultResourceHandle;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.provision.spi.AbstractResourceInstaller;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceContent;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.spi.NamedResourceAssociation;
import org.jboss.gravia.utils.IOUtils;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.gravia.GraviaExtensionLogger;

public class ResourceInstallerService
extends AbstractResourceInstaller
implements Service<ResourceInstaller> {
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedServiceModuleLoader = new InjectedValue();
    private final InjectedValue<ModelController> injectedController = new InjectedValue();
    private final InjectedValue<RuntimeEnvironment> injectedEnvironment = new InjectedValue();
    private ServerDeploymentManager serverDeploymentManager;
    private ModelControllerClient modelControllerClient;

    public ServiceController<ResourceInstaller> install(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.RESOURCE_INSTALLER_SERVICE_NAME, (Service)this);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        builder.addDependency(GraviaConstants.ENVIRONMENT_SERVICE_NAME, RuntimeEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, this.injectedServiceModuleLoader);
        builder.addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, this.injectedController);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        ModelController modelController = (ModelController)this.injectedController.getValue();
        this.modelControllerClient = modelController.createClient((Executor)Executors.newCachedThreadPool());
        this.serverDeploymentManager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.modelControllerClient);
    }

    public void stop(StopContext context) {
        try {
            this.modelControllerClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ResourceInstaller getValue() throws IllegalStateException {
        return this;
    }

    public RuntimeEnvironment getEnvironment() {
        return (RuntimeEnvironment)this.injectedEnvironment.getValue();
    }

    public ResourceHandle installSharedResource(Resource resource, Map<Requirement, Resource> mapping) throws Exception {
        GraviaExtensionLogger.LOGGER.info("Installing shared resource: {}", (Object)resource);
        ResourceIdentity identity = resource.getIdentity();
        String symbolicName = identity.getSymbolicName();
        Version version = identity.getVersion();
        File modulesDir = ((ServerEnvironment)this.injectedServerEnvironment.getValue()).getModulesDir();
        File moduleDir = new File(modulesDir, symbolicName.replace(".", File.separator) + File.separator + version);
        if (moduleDir.exists()) {
            throw new IllegalStateException("Module dir already exists: " + moduleDir);
        }
        ResourceContent content = (ResourceContent)resource.adapt(ResourceContent.class);
        if (content == null) {
            throw new IllegalStateException("Cannot obtain repository content from: " + resource);
        }
        moduleDir.mkdirs();
        File resFile = new File(moduleDir, symbolicName + "-" + version + ".jar");
        IOUtils.copyStream((InputStream)content.getContent(), (OutputStream)new FileOutputStream(resFile));
        String slot = version != Version.emptyVersion ? version.toString() : "main";
        ModuleIdentifier modid = ModuleIdentifier.create((String)symbolicName, (String)slot);
        File xmlFile = new File(moduleDir, "module.xml");
        String moduleXML = this.generateModuleXML(resFile, resource, modid, mapping);
        OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(xmlFile));
        osw.write(moduleXML);
        osw.close();
        File mainDir = new File(moduleDir.getParentFile(), "main");
        if (!mainDir.exists()) {
            mainDir.mkdirs();
            File mainFile = new File(mainDir, "module.xml");
            moduleXML = this.generateModuleAliasXML(resource, modid);
            osw = new OutputStreamWriter(new FileOutputStream(mainFile));
            osw.write(moduleXML);
            osw.close();
        }
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        org.jboss.gravia.runtime.Module module = runtime.installModule((ClassLoader)classLoader, resource, null);
        return new DefaultResourceHandle(resource, module){

            public void uninstall() {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceHandle installUnsharedResource(Resource resource, Map<Requirement, Resource> mapping) throws Exception {
        GraviaExtensionLogger.LOGGER.info("Installing unshared resource: {}", (Object)resource);
        final ServerDeploymentHelper serverDeployer = new ServerDeploymentHelper(this.serverDeploymentManager);
        final ResourceWrapper wrapper = this.getWrappedResourceContent(resource, mapping);
        String runtimeName = wrapper.getRuntimeName();
        NamedResourceAssociation.putResource((String)runtimeName, (Resource)resource);
        try {
            String deploymentName = wrapper.getDeploymentName();
            serverDeployer.deploy(deploymentName, wrapper.getInputStream());
        }
        finally {
            NamedResourceAssociation.removeResource((String)runtimeName);
        }
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        org.jboss.gravia.runtime.Module module = runtime.getModule(resource.getIdentity());
        if (module == null) {
            ModuleLoader moduleLoader = (ModuleLoader)this.injectedServiceModuleLoader.getValue();
            ModuleIdentifier modid = ModuleIdentifier.create((String)("deployment." + runtimeName));
            ModuleClassLoader classLoader = moduleLoader.loadModule(modid).getClassLoader();
            module = runtime.installModule((ClassLoader)classLoader, resource, null);
        }
        Resource modres = module != null ? (Resource)module.adapt(Resource.class) : resource;
        return new DefaultResourceHandle(modres, module){

            public void uninstall() {
                try {
                    String deploymentName = wrapper.getDeploymentName();
                    serverDeployer.undeploy(deploymentName);
                }
                catch (Throwable th) {
                    GraviaExtensionLogger.LOGGER.warn("Cannot uninstall provisioned resource: " + this.getResource(), th);
                }
            }
        };
    }

    private ResourceWrapper getWrappedResourceContent(Resource resource, Map<Requirement, Resource> mapping) {
        StringAsset structureAsset;
        JavaArchive wrapper;
        String runtimeName;
        Capability icap = resource.getIdentityCapability();
        String rtnameAtt = (String)icap.getAttribute("runtime.name");
        String string = runtimeName = rtnameAtt != null ? rtnameAtt : resource.getIdentity().getSymbolicName() + ".jar";
        if (mapping == null) {
            InputStream content = ((ResourceContent)resource.adapt(ResourceContent.class)).getContent();
            return new ResourceWrapper(runtimeName, runtimeName, content);
        }
        ConfigurationBuilder config = new ConfigurationBuilder().classLoaders(Collections.singleton(ShrinkWrap.class.getClassLoader()));
        JavaArchive archive = (JavaArchive)ShrinkWrap.createDomain((ConfigurationBuilder)config).getArchiveFactory().create(JavaArchive.class, runtimeName);
        ((ZipImporter)archive.as(ZipImporter.class)).importFrom(((ResourceContent)resource.adapt(ResourceContent.class)).getContent());
        boolean wrapAsSubdeployment = runtimeName.endsWith(".war");
        if (wrapAsSubdeployment) {
            wrapper = (JavaArchive)ShrinkWrap.createDomain((ConfigurationBuilder)config).getArchiveFactory().create(JavaArchive.class, "wrapped-" + runtimeName + ".ear");
            structureAsset = new StringAsset(this.generateSubdeploymentDeploymentStructure(resource, runtimeName, mapping));
        } else {
            wrapper = (JavaArchive)ShrinkWrap.createDomain((ConfigurationBuilder)config).getArchiveFactory().create(JavaArchive.class, "wrapped-" + runtimeName);
            structureAsset = new StringAsset(this.generateDeploymentStructure(resource, runtimeName, mapping));
        }
        wrapper.addAsManifestResource((Asset)structureAsset, "jboss-deployment-structure.xml");
        wrapper.add((Archive)archive, "/", ZipExporter.class);
        InputStream content = ((ZipExporter)wrapper.as(ZipExporter.class)).exportAsInputStream();
        return new ResourceWrapper(wrapper.getName(), runtimeName, content);
    }

    private String generateModuleXML(File resFile, Resource resource, ModuleIdentifier modid, Map<Requirement, Resource> mapping) throws IOException {
        GraviaExtensionLogger.LOGGER.info("Generating dependencies for: {}", (Object)resource);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<module xmlns='urn:jboss:module:1.3' name='" + modid.getName() + "' slot='" + modid.getSlot() + "'>");
        buffer.append(" <resources>");
        buffer.append("  <resource-root path='" + resFile.getName() + "'/>");
        buffer.append(" </resources>");
        this.addModuleDependencies(resource, mapping, buffer);
        buffer.append("</module>");
        return buffer.toString();
    }

    private String generateModuleAliasXML(Resource resource, ModuleIdentifier modid) throws IOException {
        GraviaExtensionLogger.LOGGER.info("Generating main alias for: {}", (Object)resource);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<module-alias xmlns='urn:jboss:module:1.3' name='" + modid.getName() + "' target-name='" + modid.getName() + "' target-slot='" + modid.getSlot() + "'/>");
        return buffer.toString();
    }

    private String generateDeploymentStructure(Resource res, String runtimeName, Map<Requirement, Resource> mapping) {
        GraviaExtensionLogger.LOGGER.info("Generating dependencies for: {}", (Object)res);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<jboss-deployment-structure xmlns='urn:jboss:deployment-structure:1.2'>");
        buffer.append(" <deployment>");
        buffer.append("  <resources>");
        buffer.append("   <resource-root path='" + runtimeName + "' use-physical-code-source='true'/>");
        buffer.append("  </resources>");
        this.addModuleDependencies(res, mapping, buffer);
        buffer.append(" </deployment>");
        buffer.append("</jboss-deployment-structure>");
        return buffer.toString();
    }

    private String generateSubdeploymentDeploymentStructure(Resource resource, String runtimeName, Map<Requirement, Resource> mapping) {
        GraviaExtensionLogger.LOGGER.info("Generating dependencies for: {}", (Object)resource);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<jboss-deployment-structure xmlns='urn:jboss:deployment-structure:1.2'>");
        buffer.append(" <sub-deployment name='" + runtimeName + "'>");
        buffer.append("  <resources>");
        buffer.append("   <resource-root path='" + runtimeName + "' use-physical-code-source='true'/>");
        buffer.append("  </resources>");
        this.addModuleDependencies(resource, mapping, buffer);
        buffer.append(" </sub-deployment>");
        buffer.append("</jboss-deployment-structure>");
        return buffer.toString();
    }

    private void addModuleDependencies(Resource resource, Map<Requirement, Resource> mapping, StringBuffer buffer) {
        buffer.append(" <dependencies>");
        for (Requirement req : resource.getRequirements("gravia.identity")) {
            Resource depres = mapping != null ? mapping.get(req) : null;
            if (depres == null) continue;
            ResourceIdentity identity = depres.getIdentity();
            String modname = identity.getSymbolicName();
            Version version = identity.getVersion();
            String slot = version != Version.emptyVersion ? "slot='" + version + "'" : "";
            buffer.append("<module name='" + modname + "' " + slot + "/>");
            GraviaExtensionLogger.LOGGER.info("  {}", (Object)identity);
        }
        buffer.append(" </dependencies>");
    }

    static class ResourceWrapper {
        private final String deploymentName;
        private final String runtimeName;
        private final InputStream inputStream;

        ResourceWrapper(String deploymentName, String runtimeName, InputStream inputStream) {
            this.deploymentName = deploymentName;
            this.runtimeName = runtimeName;
            this.inputStream = inputStream;
        }

        String getDeploymentName() {
            return this.deploymentName;
        }

        String getRuntimeName() {
            return this.runtimeName;
        }

        InputStream getInputStream() {
            return this.inputStream;
        }
    }
}

