/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultMatchPolicy;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.MatchPolicy;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.ResourceStore;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.gravia.GraviaConstants;

public class EnvironmentService
extends AbstractService<Environment> {
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private Environment environment;

    public ServiceController<Environment> install(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.ENVIRONMENT_SERVICE_NAME, (Service)this);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, this.injectedRuntime);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        DefaultMatchPolicy matchPolicy = new DefaultMatchPolicy();
        File modulesDir = ((ServerEnvironment)this.injectedServerEnvironment.getValue()).getModulesDir();
        this.environment = new RuntimeEnvironment(runtime, (ResourceStore)new SystemResourceStore(modulesDir), (MatchPolicy)matchPolicy);
    }

    public Environment getValue() throws IllegalStateException {
        return this.environment;
    }

    static class SystemResourceStore
    implements ResourceStore {
        private final File modulesDir;

        SystemResourceStore(File modulesDir) {
            this.modulesDir = modulesDir;
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public MatchPolicy getMatchPolicy() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Resource> getResources() {
            throw new UnsupportedOperationException();
        }

        public Resource addResource(Resource resource) {
            throw new UnsupportedOperationException();
        }

        public Resource removeResource(ResourceIdentity identity) {
            throw new UnsupportedOperationException();
        }

        public Resource getResource(ResourceIdentity identity) {
            String symbolicName = identity.getSymbolicName();
            Version version = identity.getVersion();
            String modname = symbolicName + (version != Version.emptyVersion ? ":" + version : "");
            ModuleIdentifier modid = ModuleIdentifier.fromString((String)modname);
            try {
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                moduleLoader.loadModule(modid);
            }
            catch (ModuleLoadException ex) {
                return null;
            }
            DefaultResourceBuilder builder = new DefaultResourceBuilder();
            Capability icap = builder.addIdentityCapability(symbolicName, version);
            icap.getAttributes().put("type", "abstract");
            return builder.getResource();
        }

        public Set<Capability> findProviders(Requirement requirement) {
            String symbolicName = (String)requirement.getAttribute("gravia.identity");
            VersionRange versionRange = (VersionRange)requirement.getAttribute("version");
            HashSet<Capability> result = new HashSet<Capability>();
            File moduleDir = new File(this.modulesDir, symbolicName.replace(".", File.separator));
            if (versionRange != null && moduleDir.isDirectory()) {
                for (File file : moduleDir.listFiles()) {
                    Version version;
                    if (!file.isDirectory() || file.getName().equals("main")) continue;
                    try {
                        version = new Version(file.getName());
                    }
                    catch (Throwable th) {
                        continue;
                    }
                    if (!versionRange.includes(version)) continue;
                    String modname = symbolicName + ":" + version;
                    ModuleIdentifier modid = ModuleIdentifier.fromString((String)modname);
                    try {
                        ModuleLoader moduleLoader = Module.getBootModuleLoader();
                        moduleLoader.loadModule(modid);
                    }
                    catch (ModuleLoadException ex) {
                        continue;
                    }
                    DefaultResourceBuilder builder = new DefaultResourceBuilder();
                    Capability icap = builder.addIdentityCapability(symbolicName, version);
                    icap.getAttributes().put("type", "abstract");
                    result.add(builder.getResource().getIdentityCapability());
                }
            }
            if (result.isEmpty()) {
                ModuleIdentifier modid = ModuleIdentifier.fromString((String)symbolicName);
                try {
                    ModuleLoader moduleLoader = Module.getBootModuleLoader();
                    moduleLoader.loadModule(modid);
                    DefaultResourceBuilder builder = new DefaultResourceBuilder();
                    Capability icap = builder.addIdentityCapability(symbolicName, Version.emptyVersion);
                    icap.getAttributes().put("type", "abstract");
                    result.add(builder.getResource().getIdentityCapability());
                }
                catch (ModuleLoadException ex) {
                    // empty catch block
                }
            }
            return Collections.unmodifiableSet(result);
        }
    }
}

