/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceTracker;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.ClassLoaderEntriesProvider;
import org.jboss.gravia.runtime.spi.ManifestHeadersProvider;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.gravia.GraviaExtensionLogger;
import org.wildfly.extension.gravia.service.ProvisionerService;
import org.wildfly.extension.gravia.service.RepositoryService;
import org.wildfly.extension.gravia.service.ResolverService;

public class GraviaBootstrapService
extends AbstractService<Void> {
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private Set<ServiceTracker<?, ?>> trackers;
    private Module module;

    public ServiceController<Void> install(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.GRAVIA_SUBSYSTEM_SERVICE_NAME, (Service)this);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, this.injectedRuntime);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        GraviaExtensionLogger.LOGGER.info("Activating Gravia Subsystem");
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        ModuleContext syscontext = runtime.getModuleContext();
        ModuleClassLoader classLoader = (ModuleClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        try {
            URL extensionURL = null;
            Enumeration resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL nextURL = (URL)resources.nextElement();
                if (!nextURL.getPath().contains("wildfly-extension")) continue;
                extensionURL = nextURL;
                break;
            }
            Manifest manifest = new Manifest(extensionURL.openStream());
            Dictionary headers = new ManifestHeadersProvider(manifest).getHeaders();
            this.module = runtime.installModule((ClassLoader)classLoader, headers);
            ClassLoaderEntriesProvider entriesProvider = new ClassLoaderEntriesProvider(this.module);
            AbstractModule attachable = AbstractModule.assertAbstractModule((Module)this.module);
            attachable.putAttachment(AbstractModule.MODULE_ENTRIES_PROVIDER_KEY, (Object)entriesProvider);
            this.module.start();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new StartException((Throwable)ex);
        }
        this.trackers = new HashSet();
        this.trackers.add(this.resolverTracker(syscontext, startContext.getChildTarget()));
        this.trackers.add(this.repositoryTracker(syscontext, startContext.getChildTarget()));
        this.trackers.add(this.provisionerTracker(syscontext, startContext.getChildTarget()));
    }

    public void stop(StopContext context) {
        for (ServiceTracker<?, ?> tracker : this.trackers) {
            tracker.close();
        }
        if (this.module != null) {
            this.module.uninstall();
        }
    }

    private ServiceTracker<?, ?> resolverTracker(ModuleContext syscontext, final ServiceTarget serviceTarget) {
        ServiceTracker<Resolver, Resolver> tracker = new ServiceTracker<Resolver, Resolver>(syscontext, Resolver.class, null){
            ServiceController<Resolver> controller;

            public Resolver addingService(ServiceReference<Resolver> reference) {
                Resolver resolver = (Resolver)super.addingService(reference);
                this.controller = new ResolverService(resolver).install(serviceTarget);
                return resolver;
            }

            public void remove(ServiceReference<Resolver> reference) {
                this.controller.setMode(ServiceController.Mode.REMOVE);
                super.remove(reference);
            }
        };
        tracker.open();
        return tracker;
    }

    private ServiceTracker<?, ?> repositoryTracker(ModuleContext syscontext, final ServiceTarget serviceTarget) {
        ServiceTracker<Repository, Repository> tracker = new ServiceTracker<Repository, Repository>(syscontext, Repository.class, null){
            ServiceController<Repository> controller;

            public Repository addingService(ServiceReference<Repository> reference) {
                Repository repository = (Repository)super.addingService(reference);
                this.controller = new RepositoryService(repository).install(serviceTarget);
                return repository;
            }

            public void remove(ServiceReference<Repository> reference) {
                this.controller.setMode(ServiceController.Mode.REMOVE);
                super.remove(reference);
            }
        };
        tracker.open();
        return tracker;
    }

    private ServiceTracker<?, ?> provisionerTracker(ModuleContext syscontext, final ServiceTarget serviceTarget) {
        ServiceTracker<Provisioner, Provisioner> tracker = new ServiceTracker<Provisioner, Provisioner>(syscontext, Provisioner.class, null){
            ServiceController<Provisioner> controller;

            public Provisioner addingService(ServiceReference<Provisioner> reference) {
                Provisioner provisioner = (Provisioner)super.addingService(reference);
                this.controller = new ProvisionerService(provisioner).install(serviceTarget);
                return provisioner;
            }

            public void remove(ServiceReference<Provisioner> reference) {
                this.controller.setMode(ServiceController.Mode.REMOVE);
                super.remove(reference);
            }
        };
        tracker.open();
        return tracker;
    }
}

