/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Dictionary;
import org.apache.felix.scr.component.ExtComponentContext;
import org.apache.felix.scr.impl.helper.ReadOnlyDictionary;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentInstance;

public class ComponentContextImpl
implements ExtComponentContext,
ComponentInstance {
    private AbstractComponentManager m_componentManager;

    ComponentContextImpl(AbstractComponentManager componentManager) {
        this.m_componentManager = componentManager;
    }

    protected AbstractComponentManager getComponentManager() {
        return this.m_componentManager;
    }

    public final Dictionary getProperties() {
        Dictionary ctxProperties = this.m_componentManager.getProperties();
        return new ReadOnlyDictionary(ctxProperties);
    }

    public Object locateService(String name) {
        DependencyManager dm = this.m_componentManager.getDependencyManager(name);
        return dm != null ? dm.getService() : null;
    }

    public Object locateService(String name, ServiceReference ref) {
        DependencyManager dm = this.m_componentManager.getDependencyManager(name);
        return dm != null ? dm.getService(ref) : null;
    }

    public Object[] locateServices(String name) {
        DependencyManager dm = this.m_componentManager.getDependencyManager(name);
        return dm != null ? dm.getServices() : null;
    }

    public BundleContext getBundleContext() {
        return this.m_componentManager.getActivator().getBundleContext();
    }

    public Bundle getUsingBundle() {
        return null;
    }

    public ComponentInstance getComponentInstance() {
        return this;
    }

    public void enableComponent(String name) {
        this.m_componentManager.getActivator().enableComponent(name);
    }

    public void disableComponent(String name) {
        this.m_componentManager.getActivator().disableComponent(name);
    }

    public ServiceReference getServiceReference() {
        return this.m_componentManager.getServiceReference();
    }

    public Object getInstance() {
        return this.getComponentManager().getInstance();
    }

    public void dispose() {
        this.getComponentManager().dispose();
    }

    public void setServiceProperties(Dictionary properties) {
        this.getComponentManager().setServiceProperties(properties);
    }
}

