/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.gravia.runtime.spi.ModuleEntriesProvider;
import org.jboss.gravia.utils.IllegalArgumentAssertion;
import org.jboss.vfs.VirtualFile;

public class VirtualFileEntriesProvider
implements ModuleEntriesProvider {
    private final VirtualFile rootFile;

    public VirtualFileEntriesProvider(ResourceRoot resourceRoot) {
        IllegalArgumentAssertion.assertNotNull((Object)resourceRoot, (String)"resourceRoot");
        this.rootFile = resourceRoot.getRoot();
    }

    public URL getEntry(String path) {
        try {
            VirtualFile child = this.rootFile.getChild(path);
            return child.asFileURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public List<String> getEntryPaths(String path) {
        VirtualFile pathChild = this.rootFile.getChild(path);
        List entries = pathChild.getChildren();
        ArrayList<String> result = new ArrayList<String>();
        for (VirtualFile entry : entries) {
            result.add(entry.getPathName());
        }
        return Collections.unmodifiableList(result);
    }

    public List<URL> findEntries(String path, String filePattern, boolean recurse) {
        if (filePattern == null) {
            filePattern = "*";
        }
        ArrayList<URL> result = new ArrayList<URL>();
        VirtualFile pathChild = this.rootFile.getChild(path);
        Pattern pattern = this.convertToPattern(filePattern);
        this.fillResultList(pathChild, pattern, recurse, result);
        return Collections.unmodifiableList(result);
    }

    private void fillResultList(VirtualFile pathChild, Pattern pattern, boolean recurse, List<URL> result) {
        List entries = pathChild.getChildren();
        for (VirtualFile vfile : entries) {
            int lastIndex;
            String filename;
            String resname = vfile.getPathName();
            if (resname.startsWith("/")) {
                resname = resname.substring(1);
            }
            if (!pattern.matcher(filename = (lastIndex = resname.lastIndexOf(47)) > 0 ? resname.substring(lastIndex + 1) : resname).matches()) continue;
            try {
                result.add(vfile.asFileURL());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (!recurse) continue;
            this.fillResultList(vfile, pattern, recurse, result);
        }
    }

    private Pattern convertToPattern(String filePattern) {
        filePattern = filePattern.replace("*", ".*");
        return Pattern.compile("^" + filePattern + "$");
    }
}

