/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.gravia.runtime.Filter;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceTracker;

public final class ServiceLocator {
    public static final Long DEFAULT_TIMEOUT = 10000L;

    private ServiceLocator() {
    }

    public static <T> T getService(Class<T> type) {
        ModuleContext moduleContext = RuntimeLocator.getRequiredRuntime().getModuleContext();
        ServiceReference<T> sref = moduleContext.getServiceReference(type);
        return sref != null ? (T)moduleContext.getService(sref) : null;
    }

    public static <T> T getService(ModuleContext moduleContext, Class<T> type) {
        ServiceReference<T> sref = moduleContext.getServiceReference(type);
        return sref != null ? (T)moduleContext.getService(sref) : null;
    }

    public static <T> T getRequiredService(Class<T> type) {
        return ServiceLocator.getRequiredService(RuntimeLocator.getRequiredRuntime().getModuleContext(), type);
    }

    public static <T> T getRequiredService(ModuleContext moduleContext, Class<T> type) {
        T service = ServiceLocator.getService(moduleContext, type);
        if (service == null) {
            throw new IllegalStateException("Service not available: " + type.getName());
        }
        return service;
    }

    public static <T> T awaitService(Class<T> type) {
        ModuleContext moduleContext = RuntimeLocator.getRequiredRuntime().getModuleContext();
        return ServiceLocator.awaitService(moduleContext, type, null, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(ModuleContext moduleContext, Class<T> type) {
        return ServiceLocator.awaitService(moduleContext, type, null, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(Class<T> type, String filterspec) {
        ModuleContext moduleContext = RuntimeLocator.getRequiredRuntime().getModuleContext();
        return ServiceLocator.awaitService(moduleContext, type, filterspec, DEFAULT_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public static <T> T awaitService(Class<T> type, long timeout, TimeUnit unit) {
        ModuleContext moduleContext = RuntimeLocator.getRequiredRuntime().getModuleContext();
        return ServiceLocator.awaitService(moduleContext, type, null, timeout, unit);
    }

    public static <T> T awaitService(Class<T> type, String filterspec, long timeout, TimeUnit unit) {
        ModuleContext moduleContext = RuntimeLocator.getRequiredRuntime().getModuleContext();
        return ServiceLocator.awaitService(moduleContext, type, filterspec, timeout, unit);
    }

    public static <T> T awaitService(final ModuleContext moduleContext, Class<T> type, String filterspec, long timeout, TimeUnit unit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference serviceRef = new AtomicReference();
        Filter filter = filterspec != null ? moduleContext.createFilter(filterspec) : null;
        tracker.open();
        try (ServiceTracker tracker = new ServiceTracker<T, T>(moduleContext, type, null){

            @Override
            public T addingService(ServiceReference<T> sref) {
                Object service = super.addingService(sref);
                if (this.filter == null || this.filter.match(sref)) {
                    serviceRef.set(moduleContext.getService(sref));
                    latch.countDown();
                }
                return service;
            }
        };){
            if (!latch.await(timeout, unit)) {
                String srvspec = (type != null ? type.getName() : "") + (filter != null ? filter : "");
                throw new RuntimeException("Cannot obtain service: " + srvspec);
            }
            Object srvspec = serviceRef.get();
            return (T)srvspec;
        }
    }
}

