/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.container.common;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceTracker;
import org.jboss.gravia.runtime.spi.RuntimeLogger;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;

public class HttpServiceActivator
implements ServletContextListener {
    private ServiceTracker<HttpService, HttpService> tracker;
    private static final String SYSTEM_ALIAS = "/system";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        BundleContext bundleContext = (BundleContext)servletContext.getAttribute(BundleContext.class.getName());
        final Module module = (Module)bundleContext.getBundle().adapt(Module.class);
        ModuleContext context = module.getModuleContext();
        this.tracker = new ServiceTracker<HttpService, HttpService>(context, HttpService.class, null){

            public HttpService addingService(ServiceReference<HttpService> sref) {
                HttpService service = (HttpService)super.addingService(sref);
                try {
                    RuntimeLogger.LOGGER.info("Register system HttpService with alias: /system");
                    service.registerServlet(HttpServiceActivator.SYSTEM_ALIAS, (Servlet)new HttpServiceServlet(module), null, null);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                return service;
            }

            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                RuntimeLogger.LOGGER.info("Unregister system HttpService with alias: /system");
                service.unregister(HttpServiceActivator.SYSTEM_ALIAS);
                super.removedService(reference, (Object)service);
            }
        };
        this.tracker.open();
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    static final class HttpServiceServlet
    extends HttpServlet {
        private final Module module;

        HttpServiceServlet(Module module) {
            this.module = module;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
            PrintWriter out = res.getWriter();
            out.print(this.module.getIdentity().getSymbolicName());
            out.close();
        }
    }
}

