/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.config.ComponentHolder;
import org.apache.felix.scr.impl.helper.ComponentMethods;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;
import org.apache.felix.scr.impl.manager.ComponentFactoryImpl;
import org.apache.felix.scr.impl.manager.ImmediateComponentManager;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;

public class ConfigurationComponentFactoryImpl
extends ComponentFactoryImpl
implements ComponentHolder {
    private Map m_configuredServices;

    public ConfigurationComponentFactoryImpl(BundleComponentActivator activator, ComponentMetadata metadata) {
        super(activator, metadata);
    }

    protected boolean createComponent() {
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_configuredServices, cms);
        Iterator i = cms.iterator();
        while (i.hasNext()) {
            ((AbstractComponentManager)i.next()).enable(false);
        }
        return true;
    }

    protected void deleteComponent(int reason) {
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_configuredServices, cms);
        Iterator i = cms.iterator();
        while (i.hasNext()) {
            ((AbstractComponentManager)i.next()).disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationDeleted(String pid) {
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            super.configurationDeleted(pid);
        } else {
            Map configuredServices = this.m_configuredServices;
            if (configuredServices != null) {
                ImmediateComponentManager cm;
                Map map = configuredServices;
                synchronized (map) {
                    cm = (ImmediateComponentManager)configuredServices.remove(pid);
                }
                if (cm != null) {
                    this.log(4, "Disposing component after configuration deletion", null);
                    cm.dispose();
                }
            }
        }
    }

    public void configurationUpdated(String pid, Dictionary configuration) {
        if (pid.equals(this.getComponentMetadata().getConfigurationPid())) {
            super.configurationUpdated(pid, configuration);
        } else {
            ImmediateComponentManager cm;
            Map configuredServices = this.m_configuredServices;
            if (configuredServices != null) {
                cm = (ImmediateComponentManager)configuredServices.get(pid);
            } else {
                this.m_configuredServices = new HashMap();
                configuredServices = this.m_configuredServices;
                cm = null;
            }
            if (cm == null) {
                cm = this.createConfigurationComponentManager();
                cm.reconfigure(configuration);
                if (this.getState() == 64) {
                    cm.enable(false);
                }
                configuredServices.put(pid, cm);
            } else {
                cm.reconfigure(configuration);
            }
        }
    }

    public Component[] getComponents() {
        List cms = this.getComponentList();
        this.getComponentManagers(this.m_configuredServices, cms);
        return cms.toArray(new Component[cms.size()]);
    }

    public void disposeComponents(int reason) {
        super.disposeComponents(reason);
        ArrayList cms = new ArrayList();
        this.getComponentManagers(this.m_configuredServices, cms);
        Iterator i = cms.iterator();
        while (i.hasNext()) {
            ((AbstractComponentManager)i.next()).dispose(reason);
        }
        this.m_configuredServices = null;
        this.dispose(reason);
    }

    private ImmediateComponentManager createConfigurationComponentManager() {
        return new ComponentFactoryConfiguredInstance(this.getActivator(), this, this.getComponentMetadata(), this.getComponentMethods());
    }

    static class ComponentFactoryConfiguredInstance
    extends ImmediateComponentManager {
        public ComponentFactoryConfiguredInstance(BundleComponentActivator activator, ComponentHolder componentHolder, ComponentMetadata metadata, ComponentMethods componentMethods) {
            super(activator, componentHolder, metadata, componentMethods);
        }

        public boolean isImmediate() {
            return true;
        }
    }
}

