/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.parser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.gravia.deployment.GraviaServicesProcessor;
import org.wildfly.extension.gravia.deployment.ManifestResourceProcessor;
import org.wildfly.extension.gravia.deployment.ModuleDependenciesProcessor;
import org.wildfly.extension.gravia.deployment.ModuleInstallProcessor;
import org.wildfly.extension.gravia.deployment.ModuleStartProcessor;
import org.wildfly.extension.gravia.service.EnvironmentService;
import org.wildfly.extension.gravia.service.GraviaBootstrapService;
import org.wildfly.extension.gravia.service.ModuleContextService;
import org.wildfly.extension.gravia.service.RuntimeService;
import org.wildfly.extension.gravia.service.WildFlyResourceInstaller;

public class GraviaSubsystemBootstrap {
    public static final int PARSE_GRAVIA_SERVICES_PROVIDER = 14337;
    public static final int PARSE_GRAVIA_RESOURCE = 14081;
    public static final int DEPENDENCIES_GRAVIA_RESOURCE = 6913;
    public static final int POST_MODULE_GRAVIA_MODULE_INSTALL = 513;
    public static final int INSTALL_GRAVIA_MODULE_START = 8447;

    public List<ServiceController<?>> getSubsystemServices(OperationContext context) {
        ArrayList controllers = new ArrayList();
        controllers.add(this.getBoostrapService(context));
        controllers.add(this.getResourceInstallService(context));
        controllers.add(this.getRuntimeEnvironmentService(context));
        controllers.add(this.getRuntimeService(context));
        controllers.add(this.getSystemContextService(context));
        return controllers;
    }

    protected ServiceController<?> getBoostrapService(OperationContext context) {
        return new GraviaBootstrapService().install(context.getServiceTarget());
    }

    protected ServiceController<ResourceInstaller> getResourceInstallService(OperationContext context) {
        return new WildFlyResourceInstaller().install(context.getServiceTarget());
    }

    protected ServiceController<Environment> getRuntimeEnvironmentService(OperationContext context) {
        return new EnvironmentService().install(context.getServiceTarget());
    }

    protected ServiceController<Runtime> getRuntimeService(OperationContext context) {
        return new RuntimeService().install(context.getServiceTarget());
    }

    protected ServiceController<ModuleContext> getSystemContextService(OperationContext context) {
        return new ModuleContextService().install(context.getServiceTarget());
    }

    public void addDeploymentUnitProcessors(DeploymentProcessorTarget processorTarget) {
        processorTarget.addDeploymentProcessor("gravia", Phase.PARSE, 14337, (DeploymentUnitProcessor)new GraviaServicesProcessor());
        processorTarget.addDeploymentProcessor("gravia", Phase.PARSE, 14081, (DeploymentUnitProcessor)new ManifestResourceProcessor());
        processorTarget.addDeploymentProcessor("gravia", Phase.DEPENDENCIES, 6913, (DeploymentUnitProcessor)new ModuleDependenciesProcessor());
        processorTarget.addDeploymentProcessor("gravia", Phase.POST_MODULE, 513, (DeploymentUnitProcessor)new ModuleInstallProcessor());
        processorTarget.addDeploymentProcessor("gravia", Phase.INSTALL, 8447, (DeploymentUnitProcessor)new ModuleStartProcessor());
    }
}

