/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.spi.AbstractModule;
import org.jboss.gravia.runtime.spi.ClassLoaderEntriesProvider;
import org.jboss.gravia.runtime.spi.ManifestHeadersProvider;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.gravia.GraviaExtensionLogger;

public class GraviaBootstrapService
extends AbstractService<Void> {
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private Module module;

    public ServiceController<Void> install(ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.GRAVIA_SUBSYSTEM_SERVICE_NAME, (Service)this);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, this.injectedRuntime);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        GraviaExtensionLogger.LOGGER.info("Activating Gravia Subsystem");
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        this.installExtensionModule(startContext, runtime);
    }

    public void stop(StopContext context) {
        this.uninstallExtensionModule();
    }

    public void installExtensionModule(StartContext startContext, Runtime runtime) throws StartException {
        ModuleClassLoader classLoader = (ModuleClassLoader)((Object)((Object)this)).getClass().getClassLoader();
        try {
            URL extensionURL = null;
            Enumeration resources = classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL nextURL = (URL)resources.nextElement();
                if (!nextURL.getPath().contains("wildfly-extension")) continue;
                extensionURL = nextURL;
                break;
            }
            Manifest manifest = new Manifest(extensionURL.openStream());
            Dictionary headers = new ManifestHeadersProvider(manifest).getHeaders();
            this.module = runtime.installModule((ClassLoader)classLoader, headers);
            ClassLoaderEntriesProvider entriesProvider = new ClassLoaderEntriesProvider(this.module);
            AbstractModule attachable = AbstractModule.assertAbstractModule((Module)this.module);
            attachable.putAttachment(AbstractModule.MODULE_ENTRIES_PROVIDER_KEY, (Object)entriesProvider);
            this.module.start();
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new StartException((Throwable)ex);
        }
    }

    public void uninstallExtensionModule() {
        if (this.module != null) {
            this.module.uninstall();
        }
    }
}

