/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource;

import org.jboss.gravia.resource.Version;

public final class ResourceIdentity {
    private final String symbolicName;
    private final Version version;
    private final String canonicalName;

    public static ResourceIdentity create(String symbolicName, Version version) {
        return new ResourceIdentity(symbolicName, version);
    }

    public static ResourceIdentity fromString(String identity) {
        int index = identity.indexOf(58);
        String namePart = index > 0 ? identity.substring(0, index) : identity;
        String versionPart = index > 0 ? identity.substring(index + 1) : "0.0.0";
        return new ResourceIdentity(namePart, Version.parseVersion(versionPart));
    }

    private ResourceIdentity(String symbolicName, Version version) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolicName");
        }
        this.symbolicName = symbolicName;
        this.version = version != null ? version : Version.emptyVersion;
        this.canonicalName = symbolicName + ":" + version;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceIdentity)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ResourceIdentity other = (ResourceIdentity)obj;
        return this.canonicalName.equals(other.canonicalName);
    }

    public int hashCode() {
        return this.canonicalName.hashCode();
    }

    public String toString() {
        return this.canonicalName;
    }
}

