/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.impl.helper.MethodResult;
import org.apache.felix.scr.impl.helper.SimpleLogger;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

abstract class BaseMethod {
    protected static final Class COMPONENT_CONTEXT_CLASS = ComponentContext.class;
    protected static final Class BUNDLE_CONTEXT_CLASS = BundleContext.class;
    protected static final Class SERVICE_REFERENCE_CLASS = ServiceReference.class;
    protected static final Class MAP_CLASS = Map.class;
    protected static final Class INTEGER_CLASS = Integer.class;
    private final SimpleLogger m_logger;
    private final boolean isDS11;
    private final boolean isDS12Felix;
    private final String m_methodName;
    private final Class m_componentClass;
    private volatile Method m_method;
    private final boolean m_methodRequired;
    private volatile State m_state;

    protected BaseMethod(SimpleLogger logger, String methodName, Class componentClass, boolean ds11, boolean ds12Felix) {
        this(logger, methodName, methodName != null, componentClass, ds11, ds12Felix);
    }

    protected BaseMethod(SimpleLogger logger, String methodName, boolean methodRequired, Class componentClass, boolean ds11, boolean ds12Felix) {
        this.m_logger = logger;
        this.m_methodName = methodName;
        this.m_methodRequired = methodRequired;
        this.m_componentClass = componentClass;
        this.isDS11 = ds11;
        this.isDS12Felix = ds12Felix;
        this.m_state = this.m_methodName == null ? NotApplicable.INSTANCE : NotResolved.INSTANCE;
    }

    protected final SimpleLogger getLogger() {
        return this.m_logger;
    }

    protected final boolean isDS11() {
        return this.isDS11;
    }

    protected final boolean isDS12Felix() {
        return this.isDS12Felix;
    }

    protected final String getMethodName() {
        return this.m_methodName;
    }

    protected final Method getMethod() {
        return this.m_method;
    }

    protected final Class getComponentClass() {
        return this.m_componentClass;
    }

    synchronized void setMethod(Method method) {
        this.m_method = method;
        if (method != null) {
            this.m_state = Resolved.INSTANCE;
            this.getLogger().log(4, "Found {0} method: {1}", new Object[]{this.getMethodNamePrefix(), method}, null);
        } else if (this.m_methodRequired) {
            this.m_state = NotFound.INSTANCE;
            this.getLogger().log(1, "{0} method [{1}] not found; Component will fail", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
        } else {
            this.getLogger().log(4, "{0} method [{1}] not found, ignoring", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
            this.m_state = NotApplicable.INSTANCE;
        }
    }

    State getState() {
        return this.m_state;
    }

    private Method findMethod() throws InvocationTargetException {
        boolean acceptPrivate = this.isDS11();
        boolean acceptPackage = this.isDS11();
        Class targetClass = this.getComponentClass();
        ClassLoader targetClasslLoader = targetClass.getClassLoader();
        String targetPackage = BaseMethod.getPackageName(targetClass);
        Class theClass = targetClass;
        while (theClass != null) {
            if (this.getLogger().isLogEnabled(4)) {
                this.getLogger().log(4, "Locating method " + this.getMethodName() + " in class " + theClass.getName(), null);
            }
            try {
                Method method = this.doFindMethod(theClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                this.getLogger().log(1, "findMethod: Suitable but non-accessible method {0} found in class {1}, subclass of {2}", new Object[]{this.getMethodName(), theClass.getName(), targetClass.getName()}, null);
                break;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(BaseMethod.getPackageName(theClass));
            acceptPrivate = false;
        }
        return null;
    }

    protected abstract Method doFindMethod(Class var1, boolean var2, boolean var3) throws SuitableMethodNotAccessibleException, InvocationTargetException;

    private MethodResult invokeMethod(Object componentInstance, Object rawParameter) throws InvocationTargetException {
        this.getLogger().log(4, "invoking {0}: {1}", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
        try {
            if (componentInstance != null) {
                Object[] params = this.getParameters(this.m_method, rawParameter);
                Object result = this.m_method.invoke(componentInstance, params);
                this.getLogger().log(4, "invoked {0}: {1}: parameters {2}", new Object[]{this.getMethodNamePrefix(), this.getMethodName(), Arrays.asList(params)}, null);
                return new MethodResult(this.m_method.getReturnType() != Void.TYPE, (Map)result);
            }
            this.getLogger().log(2, "Method {0} cannot be called on null object", new Object[]{this.getMethodName()}, null);
        }
        catch (IllegalStateException ise) {
            this.getLogger().log(4, ise.getMessage(), null);
            return null;
        }
        catch (IllegalAccessException ex) {
            this.getLogger().log(4, "Method {0} cannot be called", new Object[]{this.getMethodName()}, ex);
        }
        catch (InvocationTargetException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
        return MethodResult.VOID;
    }

    protected boolean returnValue() {
        return this.isDS12Felix();
    }

    protected abstract Object[] getParameters(Method var1, Object var2);

    protected String getMethodNamePrefix() {
        return "";
    }

    public Method getMethod(Class clazz, String name, Class[] parameterTypes, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            if (BaseMethod.accept(method, acceptPrivate, acceptPackage, this.returnValue())) {
                return method;
            }
            throw new SuitableMethodNotAccessibleException();
        }
        catch (NoSuchMethodException nsme) {
            if (this.getLogger().isLogEnabled(4)) {
                String argList = parameterTypes != null ? Arrays.asList(parameterTypes).toString() : "";
                this.getLogger().log(4, "Declared Method {0}.{1}({2}) not found", new Object[]{clazz.getName(), name, argList}, null);
            }
        }
        catch (NoClassDefFoundError cdfe) {
            if (this.getLogger().isLogEnabled(2)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Failure loooking up method ").append(name).append('(');
                for (int i = 0; parameterTypes != null && i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getName());
                    if (i <= 0) continue;
                    buf.append(", ");
                }
                buf.append(") in class class ").append(clazz.getName()).append(". Assuming no such method.");
                this.getLogger().log(2, buf.toString(), cdfe);
            }
        }
        catch (SuitableMethodNotAccessibleException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get method " + name);
        }
        return null;
    }

    static boolean accept(Method method, boolean acceptPrivate, boolean acceptPackage, boolean allowReturnValue) {
        if (!(Void.TYPE == method.getReturnType() || MAP_CLASS == method.getReturnType() && allowReturnValue)) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            method.setAccessible(true);
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                method.setAccessible(acceptPrivate);
                return true;
            }
            return false;
        }
        if (acceptPackage) {
            method.setAccessible(true);
            return true;
        }
        return false;
    }

    public static String getPackageName(Class clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }

    public MethodResult invoke(Object componentInstance, Object rawParameter, MethodResult methodCallFailureResult) {
        try {
            return this.m_state.invoke(this, componentInstance, rawParameter);
        }
        catch (InvocationTargetException ite) {
            this.getLogger().log(1, "The {0} method has thrown an exception", new Object[]{this.getMethodName()}, ite.getCause());
            return methodCallFailureResult;
        }
    }

    public boolean methodExists() {
        return this.m_state.methodExists(this);
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) throws InvocationTargetException {
            return baseMethod.invokeMethod(componentInstance, rawParameter);
        }

        public boolean methodExists(BaseMethod baseMethod) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) {
            baseMethod.getLogger().log(1, "{0} method [{1}] not found", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            return null;
        }

        public boolean methodExists(BaseMethod baseMethod) {
            return false;
        }
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private void resolve(BaseMethod baseMethod) {
            Method method;
            baseMethod.getLogger().log(4, "getting {0}: {1}", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            try {
                method = baseMethod.findMethod();
            }
            catch (InvocationTargetException ex) {
                method = null;
                baseMethod.getLogger().log(2, "{0} cannot be found", new Object[]{baseMethod.getMethodName()}, ex.getTargetException());
            }
            baseMethod.setMethod(method);
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) throws InvocationTargetException {
            this.resolve(baseMethod);
            return baseMethod.getState().invoke(baseMethod, componentInstance, rawParameter);
        }

        public boolean methodExists(BaseMethod baseMethod) {
            this.resolve(baseMethod);
            return baseMethod.getState().methodExists(baseMethod);
        }
    }

    private static class NotApplicable
    implements State {
        private static final State INSTANCE = new NotApplicable();

        private NotApplicable() {
        }

        public MethodResult invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) {
            return MethodResult.VOID;
        }

        public boolean methodExists(BaseMethod baseMethod) {
            return true;
        }
    }

    private static interface State {
        public MethodResult invoke(BaseMethod var1, Object var2, Object var3) throws InvocationTargetException;

        public boolean methodExists(BaseMethod var1);
    }
}

