/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.metatype.internal.BaseProviderHolder;
import org.apache.felix.metatype.internal.MetaTypeServiceImpl;
import org.apache.felix.metatype.internal.l10n.BundleResources;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final String NAME_LOG_SERVICE = (class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = Activator.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName();
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private static Activator INSTANCE;
    private ServiceTracker logService;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;
    static /* synthetic */ Class class$org$osgi$service$metatype$MetaTypeService;

    public Activator() {
        INSTANCE = this;
    }

    public void start(BundleContext context) {
        this.logService = new ServiceTracker(context, NAME_LOG_SERVICE, null);
        this.logService.open();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", "org.apache.felix.metatype.MetaTypeService");
        ((Dictionary)props).put("service.description", "MetaTypeService Specification 1.2 Implementation");
        ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
        MetaTypeServiceImpl metaTypeService = new MetaTypeServiceImpl(context);
        context.registerService((class$org$osgi$service$metatype$MetaTypeService == null ? (class$org$osgi$service$metatype$MetaTypeService = Activator.class$("org.osgi.service.metatype.MetaTypeService")) : class$org$osgi$service$metatype$MetaTypeService).getName(), (Object)metaTypeService, props);
    }

    public void stop(BundleContext context) {
        this.logService.close();
        BundleResources.clearResourcesCache();
    }

    public static void log(int level, String message) {
        LogService log = (LogService)Activator.INSTANCE.logService.getService();
        if (log == null) {
            Activator._log(null, level, message, null);
        } else {
            log.log(level, message);
        }
    }

    public static void log(int level, String message, Throwable exception) {
        LogService log = (LogService)Activator.INSTANCE.logService.getService();
        if (log == null) {
            Activator._log(null, level, message, exception);
        } else {
            log.log(level, message, exception);
        }
    }

    public static void log(ServiceReference sr, int level, String message) {
        LogService log = (LogService)Activator.INSTANCE.logService.getService();
        if (log == null) {
            Activator._log(sr, level, message, null);
        } else {
            log.log(sr, level, message);
        }
    }

    public static void log(ServiceReference sr, int level, String message, Throwable exception) {
        LogService log = (LogService)Activator.INSTANCE.logService.getService();
        if (log == null) {
            Activator._log(sr, level, message, exception);
        } else {
            log.log(sr, level, message, exception);
        }
    }

    private static void _log(ServiceReference sr, int level, String message, Throwable exception) {
        String time = Activator.getTimeStamp();
        StringBuffer buf = new StringBuffer(time);
        buf.append(' ').append(Activator.toLevelString(level)).append(' ');
        buf.append(message);
        if (sr != null) {
            String[] pids = BaseProviderHolder.getServicePids(sr);
            String name = pids != null ? pids[0] : ((String[])sr.getProperty("objectClass"))[0];
            buf.append(" (").append(name).append(", service.id=").append(sr.getProperty("service.id")).append(')');
        }
        PrintStream dst = level == 1 ? System.err : System.out;
        dst.println(buf);
        if (exception != null) {
            buf = new StringBuffer(time);
            buf.append(' ').append(Activator.toLevelString(level)).append(' ');
            dst.print(buf);
            exception.printStackTrace(dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTimeStamp() {
        SimpleDateFormat simpleDateFormat = FORMAT;
        synchronized (simpleDateFormat) {
            return FORMAT.format(new Date());
        }
    }

    private static String toLevelString(int level) {
        switch (level) {
            case 4: {
                return "*DEBUG*";
            }
            case 3: {
                return "*INFO *";
            }
            case 2: {
                return "*WARN *";
            }
            case 1: {
                return "*ERROR*";
            }
        }
        return "*" + level + "*";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

