/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.repository.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.gravia.repository.PersistentRepository;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.repository.RepositoryStorage;
import org.jboss.gravia.repository.spi.AbstractRepository;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;

public abstract class AbstractPersistentRepository
extends AbstractRepository
implements PersistentRepository {
    private final Repository.ConfigurationPropertyProvider propertyProvider;
    private final Repository delegate;
    private RepositoryStorage storage;

    public AbstractPersistentRepository(Repository.ConfigurationPropertyProvider propertyProvider) {
        this(propertyProvider, null);
    }

    public AbstractPersistentRepository(Repository.ConfigurationPropertyProvider propertyProvider, Repository delegate) {
        this.propertyProvider = propertyProvider;
        this.delegate = delegate;
    }

    protected abstract RepositoryStorage createRepositoryStorage(PersistentRepository var1, Repository.ConfigurationPropertyProvider var2);

    protected Repository.ConfigurationPropertyProvider getConfigurationPropertyProvider() {
        return this.propertyProvider;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public <T> T adapt(Class<T> type) {
        Object result = null;
        if (type.isAssignableFrom(this.getClass())) {
            result = this;
        } else if (RepositoryStorage.class.isAssignableFrom(type)) {
            result = this.getRepositoryStorage();
        } else if (this.delegate != null) {
            result = this.delegate.adapt(type);
        }
        return (T)result;
    }

    @Override
    public RepositoryStorage getRepositoryStorage() {
        if (this.storage == null) {
            this.storage = this.createRepositoryStorage(this, this.getConfigurationPropertyProvider());
        }
        return this.storage;
    }

    @Override
    public Repository getDelegate() {
        return this.delegate;
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<Requirement> reqs) {
        if (reqs == null) {
            throw new IllegalArgumentException("Null reqs");
        }
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement req : reqs) {
            Collection<Capability> providers = this.findProviders(req);
            result.put(req, providers);
        }
        return result;
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        if (req == null) {
            throw new IllegalArgumentException("Null req");
        }
        HashSet<Capability> providers = this.getRepositoryStorage().findProviders(req);
        if (providers.isEmpty() && this.getDelegate() != null) {
            providers = new HashSet<Capability>();
            for (Capability cap : this.getDelegate().findProviders(req)) {
                Resource res = cap.getResource();
                ResourceIdentity resid = res.getIdentity();
                Resource storageResource = this.getRepositoryStorage().getResource(resid);
                if (storageResource == null) {
                    storageResource = this.getRepositoryStorage().addResource(res);
                    for (Capability aux : storageResource.getCapabilities(req.getNamespace())) {
                        if (!cap.getAttributes().equals(aux.getAttributes())) continue;
                        cap = aux;
                        break;
                    }
                }
                providers.add(cap);
            }
        }
        return Collections.unmodifiableCollection(providers);
    }
}

