/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.util.Properties;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.embedded.EmbeddedRuntimeFactory;
import org.jboss.gravia.runtime.spi.PropertiesProvider;
import org.jboss.gravia.runtime.spi.RuntimeFactory;
import org.jboss.gravia.runtime.util.DefaultPropertiesProvider;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.security.manager.WildFlySecurityManager;

public class RuntimeService
extends AbstractService<Runtime> {
    public static ServiceController<Runtime> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        RuntimeService service = new RuntimeService();
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.RUNTIME_SERVICE_NAME, (Service)service);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private RuntimeService() {
    }

    public void start(StartContext startContext) throws StartException {
        Properties props = WildFlySecurityManager.getSystemPropertiesPrivileged();
        DefaultPropertiesProvider propsProvider = new DefaultPropertiesProvider(props);
        Runtime runtime = RuntimeLocator.createRuntime((RuntimeFactory)new EmbeddedRuntimeFactory(), (PropertiesProvider)propsProvider);
        runtime.init();
    }

    public Runtime getValue() throws IllegalStateException {
        return RuntimeLocator.getRuntime();
    }
}

