/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.runtime.embedded.osgi;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.ModuleEvent;
import org.jboss.gravia.runtime.ModuleListener;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceFactory;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.gravia.runtime.SynchronousModuleListener;
import org.jboss.gravia.runtime.embedded.osgi.BundleAdaptor;
import org.jboss.gravia.runtime.embedded.osgi.ServiceReferenceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.SynchronousBundleListener;

public final class BundleContextAdaptor
implements BundleContext {
    private final ModuleContext moduleContext;

    public BundleContextAdaptor(ModuleContext moduleContext) {
        this.moduleContext = moduleContext;
    }

    public Bundle getBundle() {
        Module module = this.moduleContext.getModule();
        return new BundleAdaptor(module);
    }

    public String getProperty(String key) {
        Object value = this.getRuntime().getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    public Bundle getBundle(long id) {
        Module module = this.getRuntime().getModule(id);
        return module != null ? new BundleAdaptor(module) : null;
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        throw new UnsupportedOperationException("BundleContext.installBundle(String,InputStream)");
    }

    public Bundle installBundle(String location) throws BundleException {
        throw new UnsupportedOperationException("BundleContext.installBundle(String)");
    }

    public Bundle getBundle(String location) {
        throw new UnsupportedOperationException("BundleContext.getBundle(String)");
    }

    public Bundle[] getBundles() {
        ArrayList<BundleAdaptor> bundles = new ArrayList<BundleAdaptor>();
        for (Module module : this.getRuntime().getModules()) {
            bundles.add(new BundleAdaptor(module));
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public void addServiceListener(org.osgi.framework.ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.moduleContext.addServiceListener((ServiceListener)new ServiceListenerAdaptor(listener), filter);
    }

    public void addServiceListener(org.osgi.framework.ServiceListener listener) {
        this.moduleContext.addServiceListener((ServiceListener)new ServiceListenerAdaptor(listener));
    }

    public void removeServiceListener(org.osgi.framework.ServiceListener listener) {
        this.moduleContext.removeServiceListener((ServiceListener)new ServiceListenerAdaptor(listener));
    }

    public void addBundleListener(BundleListener listener) {
        this.moduleContext.addModuleListener(this.adaptBundleListener(listener));
    }

    public void removeBundleListener(BundleListener listener) {
        this.moduleContext.removeModuleListener((ModuleListener)new BundleListenerAdaptor(listener));
    }

    public void addFrameworkListener(FrameworkListener listener) {
        throw new UnsupportedOperationException("BundleContext.addFrameworkListener(FrameworkListener)");
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        throw new UnsupportedOperationException("BundleContext.removeFrameworkListener(FrameworkListener)");
    }

    public org.osgi.framework.ServiceRegistration<?> registerService(String[] classNames, Object service, Dictionary<String, ?> properties) {
        return new ServiceRegistrationAdaptor(this.moduleContext.registerService(classNames, this.adaptServiceFactory(service), properties));
    }

    public org.osgi.framework.ServiceRegistration<?> registerService(String className, Object service, Dictionary<String, ?> properties) {
        return new ServiceRegistrationAdaptor(this.moduleContext.registerService(className, this.adaptServiceFactory(service), properties));
    }

    public <S> org.osgi.framework.ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return new ServiceRegistrationAdaptor(this.moduleContext.registerService(clazz, this.adaptServiceFactory(service), properties));
    }

    public org.osgi.framework.ServiceReference<?>[] getServiceReferences(String className, String filter) throws InvalidSyntaxException {
        ServiceReference[] srefs = this.moduleContext.getServiceReferences(className, filter);
        if (srefs == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (ServiceReference sref : srefs) {
            result.add(new ServiceReferenceAdaptor(sref));
        }
        return result.toArray(new org.osgi.framework.ServiceReference[result.size()]);
    }

    public <S> Collection<org.osgi.framework.ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        Collection srefs = this.moduleContext.getServiceReferences(clazz, filter);
        ArrayList result = new ArrayList();
        for (ServiceReference sref : srefs) {
            result.add(new ServiceReferenceAdaptor(sref));
        }
        return Collections.unmodifiableList(result);
    }

    public org.osgi.framework.ServiceReference<?>[] getAllServiceReferences(String className, String filter) throws InvalidSyntaxException {
        ServiceReference[] srefs = this.moduleContext.getAllServiceReferences(className, filter);
        if (srefs == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        for (ServiceReference sref : srefs) {
            result.add(new ServiceReferenceAdaptor(sref));
        }
        return result.toArray(new org.osgi.framework.ServiceReference[result.size()]);
    }

    public org.osgi.framework.ServiceReference<?> getServiceReference(String className) {
        ServiceReference sref = this.moduleContext.getServiceReference(className);
        return sref != null ? new ServiceReferenceAdaptor(sref) : null;
    }

    public <S> org.osgi.framework.ServiceReference<S> getServiceReference(Class<S> clazz) {
        ServiceReference sref = this.moduleContext.getServiceReference(clazz);
        return sref != null ? new ServiceReferenceAdaptor(sref) : null;
    }

    public <S> S getService(org.osgi.framework.ServiceReference<S> reference) {
        ServiceReferenceAdaptor adaptor = (ServiceReferenceAdaptor)reference;
        return (S)this.moduleContext.getService(adaptor.delegate);
    }

    public boolean ungetService(org.osgi.framework.ServiceReference<?> reference) {
        ServiceReferenceAdaptor adaptor = (ServiceReferenceAdaptor)reference;
        return this.moduleContext.ungetService(adaptor.delegate);
    }

    public File getDataFile(String filename) {
        return this.moduleContext.getModule().getDataFile(filename);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)filter);
    }

    private Runtime getRuntime() {
        return (Runtime)this.moduleContext.getModule().adapt(Runtime.class);
    }

    private <S> S adaptServiceFactory(S service) {
        if (service instanceof org.osgi.framework.ServiceFactory) {
            org.osgi.framework.ServiceFactory factory = (org.osgi.framework.ServiceFactory)service;
            service = new ServiceFactoryAdaptor(factory);
        }
        return service;
    }

    private ModuleListener adaptBundleListener(BundleListener listener) {
        if (listener instanceof SynchronousBundleListener) {
            return new SynchronousBundleListenerAdaptor(listener);
        }
        return new BundleListenerAdaptor(listener);
    }

    public String toString() {
        return "BundleContext[" + this.moduleContext.getModule().getIdentity() + "]";
    }

    private class ServiceFactoryAdaptor<S>
    implements ServiceFactory<S> {
        private final org.osgi.framework.ServiceFactory<S> delegate;

        ServiceFactoryAdaptor(org.osgi.framework.ServiceFactory<S> delegate) {
            this.delegate = delegate;
        }

        public S getService(Module module, ServiceRegistration<S> registration) {
            return (S)this.delegate.getService((Bundle)new BundleAdaptor(module), new ServiceRegistrationAdaptor<S>(registration));
        }

        public void ungetService(Module module, ServiceRegistration<S> registration, S service) {
            this.delegate.ungetService((Bundle)new BundleAdaptor(module), new ServiceRegistrationAdaptor<S>(registration), service);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ServiceRegistrationAdaptor<S>
    implements org.osgi.framework.ServiceRegistration<S> {
        private final ServiceRegistration<S> delegate;

        ServiceRegistrationAdaptor(ServiceRegistration<S> delegate) {
            this.delegate = delegate;
        }

        public org.osgi.framework.ServiceReference<S> getReference() {
            return new ServiceReferenceAdaptor(this.delegate.getReference());
        }

        public void setProperties(Dictionary<String, ?> properties) {
            this.delegate.setProperties(properties);
        }

        public void unregister() {
            this.delegate.unregister();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ServiceReferenceAdaptor<S>
    implements org.osgi.framework.ServiceReference<S> {
        private final ServiceReference<S> delegate;

        ServiceReferenceAdaptor(ServiceReference<S> delegate) {
            this.delegate = delegate;
        }

        public Object getProperty(String key) {
            return this.delegate.getProperty(key);
        }

        public String[] getPropertyKeys() {
            return this.delegate.getPropertyKeys();
        }

        public Bundle getBundle() {
            Module module = this.delegate.getModule();
            return new BundleAdaptor(module);
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException("BundleContext.getUsingBundles()");
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            Module module = this.mappedModule(bundle);
            return this.delegate.isAssignableTo(module, className);
        }

        public int compareTo(Object sref) {
            if (!(sref instanceof org.osgi.framework.ServiceReference)) {
                throw new IllegalArgumentException("Invalid ServiceReference: " + sref);
            }
            Comparator<org.osgi.framework.ServiceReference<?>> comparator = ServiceReferenceComparator.getInstance();
            return comparator.compare(this, (org.osgi.framework.ServiceReference)sref);
        }

        private Module mappedModule(Bundle bundle) {
            Module result = null;
            if (bundle != null) {
                Runtime runtime = RuntimeLocator.getRuntime();
                result = runtime.getModule(bundle.getBundleId());
            }
            return result;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class ServiceListenerAdaptor
    implements ServiceListener {
        private final org.osgi.framework.ServiceListener delegate;

        ServiceListenerAdaptor(org.osgi.framework.ServiceListener delegate) {
            this.delegate = delegate;
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReferenceAdaptor sref = new ServiceReferenceAdaptor(event.getServiceReference());
            this.delegate.serviceChanged(new org.osgi.framework.ServiceEvent(event.getType(), sref));
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ServiceListenerAdaptor)) {
                return false;
            }
            ServiceListenerAdaptor other = (ServiceListenerAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class BundleListenerAdaptor
    implements ModuleListener {
        private final BundleListener delegate;

        BundleListenerAdaptor(BundleListener delegate) {
            this.delegate = delegate;
        }

        public void moduleChanged(ModuleEvent event) {
            int type = event.getType();
            Module module = event.getModule();
            BundleEvent bundleEvent = new BundleEvent(type, (Bundle)new BundleAdaptor(module));
            this.delegate.bundleChanged(bundleEvent);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BundleListenerAdaptor)) {
                return false;
            }
            BundleListenerAdaptor other = (BundleListenerAdaptor)obj;
            return this.delegate.equals(other.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private class SynchronousBundleListenerAdaptor
    extends BundleListenerAdaptor
    implements SynchronousModuleListener {
        SynchronousBundleListenerAdaptor(BundleListener delegate) {
            super(delegate);
        }
    }
}

