/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.config;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.scr.impl.config.ScrManagedService;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

class ScrManagedServiceMetaTypeProvider
extends ScrManagedService
implements MetaTypeProvider {
    static ManagedService create(ScrConfiguration scrConfiguration) {
        return new ScrManagedServiceMetaTypeProvider(scrConfiguration);
    }

    private ScrManagedServiceMetaTypeProvider(ScrConfiguration scrConfiguration) {
        super(scrConfiguration);
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!"org.apache.felix.scr.ScrService".equals(id)) {
            return null;
        }
        final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
        adList.add(new AttributeDefinitionImpl("ds.loglevel", "SCR Log Level", "Allows limiting the amount of logging information sent to the OSGi LogService. Supported values are DEBUG, INFO, WARN, and ERROR. Default is ERROR.", 3, new String[]{String.valueOf(this.getScrConfiguration().getLogLevel())}, 0, new String[]{"Debug", "Information", "Warnings", "Error"}, new String[]{"4", "3", "2", "1"}));
        adList.add(new AttributeDefinitionImpl("ds.factory.enabled", "Extended Factory Components", "Whether or not to enable the support for creating Factory Component instances based on factory configuration. This is an Apache Felix SCR specific extension, explicitly not supported by the Declarative Services specification. Reliance on this feature prevent the component from being used with other Declarative Services implementations. The default value is false to disable this feature.", this.getScrConfiguration().isFactoryEnabled()));
        adList.add(new AttributeDefinitionImpl("ds.delayed.keepInstances", "Keep Component Instances", "Whether or not to keep instances of delayed components once they are not referred to any more. The Declarative Services specifications suggests that instances of delayed components are disposed off if there is not used any longer. Setting this flag causes the components to not be disposed off and thus prevent them from being constantly recreated if often used. Examples of such components may be EventHandler services. The default is to dispose off unused components.", this.getScrConfiguration().keepInstances()));
        return new ObjectClassDefinition(){
            private final AttributeDefinition[] attrs;
            {
                this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
            }

            public String getName() {
                return "Apache Felix Declarative Service Implementation";
            }

            public InputStream getIcon(int arg0) {
                return null;
            }

            public String getID() {
                return "org.apache.felix.scr.ScrService";
            }

            public String getDescription() {
                return "Configuration for the Apache Felix Declarative Services Implementation. This configuration overwrites configuration defined in framework properties of the same names.";
            }

            public AttributeDefinition[] getAttributeDefinitions(int filter) {
                return filter == 2 ? null : this.attrs;
            }
        };
    }

    private static class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description, boolean defaultValue) {
            this(id, name, description, 11, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

