/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.test.gravia.itests.sub.d.ServiceD;
import org.jboss.test.gravia.itests.sub.d1.ServiceD1;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ConfigurationAdminTest {
    @Test
    public void testBasicModule() throws Exception {
        Runtime runtime = RuntimeLocator.getRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        ModuleContext ctxA = module.getModuleContext();
        ServiceReference srefD = ctxA.getServiceReference(ServiceD.class);
        Assert.assertNotNull((String)"ServiceReference not null", (Object)srefD);
        ServiceD srvD = (ServiceD)ctxA.getService(srefD);
        Assert.assertEquals((Object)"ServiceD#1:ServiceD1#1:null:Hello", (Object)srvD.doStuff("Hello"));
        ConfigurationAdmin configAdmin = this.getConfigurationAdmin(module);
        Configuration config = configAdmin.getConfiguration(ServiceD1.class.getName());
        Assert.assertNotNull((String)"Config not null", (Object)config);
        Assert.assertNull((String)("Config is empty, but was: " + config.getProperties()), (Object)config.getProperties());
        Hashtable<String, String> configProps = new Hashtable<String, String>();
        ((Dictionary)configProps).put("foo", "bar");
        config.update(configProps);
        ServiceD1 srvD1 = srvD.getServiceD1();
        Assert.assertTrue((boolean)srvD1.awaitModified(4000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((Object)"ServiceD#1:ServiceD1#1:bar:Hello", (Object)srvD.doStuff("Hello"));
    }

    protected ConfigurationAdmin getConfigurationAdmin(Module module) {
        ModuleContext context = module.getModuleContext();
        return (ConfigurationAdmin)context.getService(context.getServiceReference(ConfigurationAdmin.class));
    }
}

