/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class ArchiveBuilder {
    private final String name;
    private final Archive<?> archive;

    public ArchiveBuilder(String name) {
        this.name = name;
        this.archive = ArchiveBuilder.getTargetContainer() == TargetContainer.tomcat ? (Archive)ShrinkWrap.create(WebArchive.class, (String)(name + ".war")) : (Archive)ShrinkWrap.create(JavaArchive.class, (String)(name + ".jar"));
    }

    public String getName() {
        return this.name;
    }

    public static TargetContainer getTargetContainer() {
        return TargetContainer.valueOf(System.getProperty("target.container"));
    }

    public ArchiveBuilder addClasses(Class<?> ... classes) {
        ClassContainer container = (ClassContainer)this.archive;
        container.addClasses((Class[])classes);
        return this;
    }

    public ArchiveBuilder addClasses(TargetContainer target, Class<?> ... classes) {
        if (ArchiveBuilder.getTargetContainer() == target) {
            ClassContainer container = (ClassContainer)this.archive;
            container.addClasses((Class[])classes);
        }
        return this;
    }

    public ArchiveBuilder addAsResource(String resname) {
        if (this.archive instanceof WebContainer) {
            WebContainer container = (WebContainer)this.archive;
            container.addAsWebResource(resname, resname);
        } else {
            ResourceContainer container = (ResourceContainer)this.archive;
            container.addAsResource(resname);
        }
        return this;
    }

    public ArchiveBuilder setManifest(Asset manifestAsset) {
        ManifestContainer container = (ManifestContainer)this.archive;
        container.setManifest(manifestAsset);
        return this;
    }

    public Archive<?> getArchive() {
        return this.archive;
    }

    public static enum TargetContainer {
        karaf,
        tomcat,
        wildfly;

    }
}

