/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.container.tomcat.extension.ModuleLifecycleListener;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.embedded.spi.HttpServiceProxyListener;
import org.jboss.gravia.runtime.embedded.spi.HttpServiceProxyServlet;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.gravia.itests.ArchiveBuilder;
import org.jboss.test.gravia.itests.support.HttpRequest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.http.HttpService;

@RunWith(value=Arquillian.class)
public class HttpServiceTestCase {
    static StringAsset STRING_ASSET = new StringAsset("Hello from Resource");

    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"http-service.war");
        archive.addClasses(new Class[]{ModuleLifecycleListener.class, HttpServiceProxyServlet.class, HttpServiceProxyListener.class});
        archive.addClasses(new Class[]{HttpRequest.class});
        archive.addAsResource((Asset)STRING_ASSET, "res/message.txt");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == ArchiveBuilder.TargetContainer.karaf) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName("http-service");
                    builder.addBundleVersion("1.0.0");
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addImportPackages(new Class[]{RuntimeLocator.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability("http-service", "1.0.0");
                builder.addManifestHeader("Dependencies", "org.jboss.gravia,org.jboss.shrinkwrap.core");
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletAccess() throws Exception {
        Runtime runtime = RuntimeLocator.getRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        ModuleContext context = module.getModuleContext();
        ServiceReference sref = context.getServiceReference(HttpService.class);
        HttpService httpService = (HttpService)context.getService(sref);
        String reqspec = "/service?test=param&param=Kermit";
        try {
            this.assertNotAvailable(reqspec);
            httpService.registerServlet("/service", (Servlet)new HttpServiceServlet(module), null, null);
            Assert.assertEquals((Object)"Hello: Kermit", (Object)this.performCall(reqspec));
            httpService.unregister("/service");
            this.assertNotAvailable(reqspec);
            this.assertNotAvailable(reqspec);
        }
        finally {
            context.ungetService(sref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceAccess() throws Exception {
        Runtime runtime = RuntimeLocator.getRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        ModuleContext context = module.getModuleContext();
        ServiceReference sref = context.getServiceReference(HttpService.class);
        HttpService httpService = (HttpService)context.getService(sref);
        String reqspec = "/resource/message.txt";
        try {
            this.assertNotAvailable(reqspec);
            httpService.registerResources("/resource", "/res", null);
            Assert.assertEquals((Object)"Hello from Resource", (Object)this.performCall(reqspec));
            httpService.unregister("/resource");
            this.assertNotAvailable(reqspec);
        }
        finally {
            context.ungetService(sref);
        }
    }

    private void assertNotAvailable(String reqspec) throws Exception {
        try {
            this.performCall(reqspec);
            Assert.fail((String)"IOException expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String performCall(String path) throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Object runtimeType = runtime.getProperty("org.jboss.gravia.runtime.type");
        String context = "karaf".equals(runtimeType) ? "" : "/http-service";
        return HttpRequest.get("http://localhost:8080" + context + path, 2L, TimeUnit.SECONDS);
    }

    static final class HttpServiceServlet
    extends HttpServlet {
        private final Module module;

        HttpServiceServlet(Module module) {
            this.module = module;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
            PrintWriter out = res.getWriter();
            String type = req.getParameter("test");
            if ("param".equals(type)) {
                String value = req.getParameter("param");
                out.print("Hello: " + value);
            } else if ("init".equals(type)) {
                String key = req.getParameter("init");
                String value = this.getInitParameter(key);
                out.print(key + "=" + value);
            } else if ("instance".equals(type)) {
                out.print(this.module.getIdentity());
            } else {
                throw new IllegalArgumentException("Invalid 'test' parameter: " + type);
            }
            out.close();
        }
    }
}

