/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpRequest {
    public static String get(final String spec, final long timeout, final TimeUnit unit) throws IOException {
        try {
            Callable<String> task = new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return HttpRequest.processResponse(new URL(spec), timeout, unit);
                }
            };
            return HttpRequest.execute(task, timeout, unit);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new IOException("Error accessing: " + spec, ex);
        }
    }

    private static String execute(Callable<String> task, long timeout, TimeUnit unit) throws TimeoutException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<String> result = executor.submit(task);
        try {
            String string = result.get(timeout, unit);
            return string;
        }
        catch (TimeoutException e) {
            result.cancel(true);
            throw e;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            executor.shutdownNow();
            try {
                executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {}
        }
    }

    private static String read(InputStream in) throws IOException {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processResponse(URL url, long timeout, TimeUnit unit) throws IOException {
        int responseCode = 0;
        String lastError = "No Error";
        String lastResult = "No Result";
        long now = System.currentTimeMillis();
        long start = System.currentTimeMillis();
        while (responseCode != 200 && now < start + unit.toMillis(timeout)) {
            block14: {
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setDoInput(true);
                try {
                    responseCode = con.getResponseCode();
                    if (responseCode != 200) {
                        InputStream err = con.getErrorStream();
                        try {
                            lastError = HttpRequest.read(err);
                            break block14;
                        }
                        finally {
                            err.close();
                        }
                    }
                    InputStream in = con.getInputStream();
                    try {
                        lastResult = HttpRequest.read(in);
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    con.disconnect();
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                lastError = ex.toString();
                break;
            }
            now = System.currentTimeMillis();
        }
        if (responseCode != 200) {
            throw new IOException(lastError);
        }
        return lastResult;
    }
}

