/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.arquillian.container.ContainerSetup;
import org.jboss.gravia.arquillian.container.ContainerSetupTask;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.IdentityRequirementBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.resource.Wiring;
import org.jboss.gravia.runtime.ModuleActivatorBridge;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.gravia.runtime.WebAppContextListener;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.test.gravia.itests.sub.b.CamelTransformActivator;
import org.jboss.test.gravia.itests.support.AnnotatedContextListener;
import org.jboss.test.gravia.itests.support.AnnotatedProxyListener;
import org.jboss.test.gravia.itests.support.AnnotatedProxyServlet;
import org.jboss.test.gravia.itests.support.ArchiveBuilder;
import org.jboss.test.gravia.itests.support.HttpRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.http.HttpService;

@RunWith(value=Arquillian.class)
@ContainerSetup(value={Setup.class})
public class ProvisionerServiceTest {
    static final String DEPLOYMENT_B = "deploymentB";
    static final String RESOURCE_B = "resourceB";
    @ArquillianResource
    Deployer deployer;
    private Provisioner provisioner;

    @Deployment
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("provisioner-service");
        archive.addClasses(HttpRequest.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, Provisioner.class, Resolver.class, Repository.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Before
    public void setUp() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ModuleContext syscontext = runtime.getModuleContext();
        ServiceReference sref = syscontext.getServiceReference(Provisioner.class);
        Assert.assertNotNull((String)"Provisioner reference not null", (Object)sref);
        this.provisioner = (Provisioner)syscontext.getService(sref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeploymentWithDependency() throws Exception {
        ResourceIdentity identity = ResourceIdentity.fromString((String)"camel.core.feature:0.0.0");
        Requirement req = new IdentityRequirementBuilder(identity).getRequirement();
        Set result = this.provisioner.provisionResources(Collections.singleton(req));
        Assert.assertEquals((String)"One resource", (long)1L, (long)result.size());
        ArrayList<ResourceHandle> handles = new ArrayList<ResourceHandle>(result);
        try {
            Environment environment = this.provisioner.getEnvironment();
            Map wirings = environment.getWirings();
            ResourceIdentity residA = ResourceIdentity.create((String)"org.apache.camel.core", (String)"2.11.0");
            Resource resA = environment.getResource(residA);
            Assert.assertNotNull((String)"Resource in environment", (Object)resA);
            Wiring wiringA = (Wiring)wirings.get(resA);
            Assert.assertNotNull((String)"Wiring in environment", (Object)wiringA);
            Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
            Assert.assertEquals((String)"Zero provided wires", (long)0L, (long)wiringA.getProvidedResourceWires(null).size());
            DefaultResourceBuilder builder = new DefaultResourceBuilder();
            ResourceIdentity residB = ResourceIdentity.create((String)DEPLOYMENT_B, (Version)Version.emptyVersion);
            Capability icap = builder.addIdentityCapability(residB);
            icap.getAttributes().put("runtime.name", "deploymentB.war");
            builder.addContentCapability(this.deployer.getDeployment(DEPLOYMENT_B));
            Resource resB = builder.getResource();
            ResourceInstaller installer = this.provisioner.getResourceInstaller();
            handles.add(installer.installResource(resB, null));
            Assert.assertEquals((String)"Two resources", (long)2L, (long)handles.size());
            String reqspec = "/service?test=Kermit";
            String context = RuntimeType.getRuntimeType() == RuntimeType.KARAF ? "" : "/deploymentB";
            Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(context, reqspec));
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residA));
            Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residB));
            wirings = environment.getWirings();
            resA = environment.getResource(residA);
            Assert.assertNotNull((String)"Resource in environment", (Object)resA);
            wiringA = (Wiring)wirings.get(resA);
            Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
            Assert.assertEquals((String)"Zero provided wires", (long)0L, (long)wiringA.getProvidedResourceWires(null).size());
            resB = environment.getResource(residB);
            Assert.assertNotNull((String)"Resource in environment", (Object)resB);
            Wiring wiringB = (Wiring)wirings.get(resB);
            Assert.assertNull((String)"Wiring not in environment", (Object)wiringB);
        }
        finally {
            for (ResourceHandle handle : handles) {
                handle.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionResources() throws Exception {
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        Capability icap = builder.addIdentityCapability(RESOURCE_B, Version.emptyVersion);
        icap.getAttributes().put("runtime.name", "resourceB.war");
        builder.addContentCapability(this.deployer.getDeployment(RESOURCE_B));
        builder.addIdentityRequirement("org.apache.camel.core", new VersionRange("[2.11,3.0)"));
        Resource res = builder.getResource();
        Repository repository = this.provisioner.getRepository();
        Resource resB = repository.addResource(res);
        Assert.assertEquals((Object)"resourceB:0.0.0", (Object)resB.getIdentity().toString());
        try {
            Requirement req = new IdentityRequirementBuilder(resB.getIdentity()).getRequirement();
            Set result = this.provisioner.provisionResources(Collections.singleton(req));
            ArrayList handles = new ArrayList(result);
            try {
                String reqspec = "/service?test=Kermit";
                String context = RuntimeType.getRuntimeType() == RuntimeType.KARAF ? "" : "/resourceB";
                Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(context, reqspec));
                Runtime runtime = RuntimeLocator.getRequiredRuntime();
                ResourceIdentity residA = ResourceIdentity.create((String)"org.apache.camel.core", (String)"2.11.0");
                Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residA));
                ResourceIdentity residB = ResourceIdentity.create((String)RESOURCE_B, (Version)Version.emptyVersion);
                Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residB));
                Environment environment = this.provisioner.getEnvironment();
                Map wirings = environment.getWirings();
                Resource resA = environment.getResource(residA);
                Assert.assertNotNull((String)"Resource in environment", (Object)resA);
                Wiring wiringA = (Wiring)wirings.get(resA);
                Assert.assertNotNull((String)"Wiring in environment", (Object)wiringA);
                Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
                Assert.assertEquals((String)"One provided wires", (long)1L, (long)wiringA.getProvidedResourceWires(null).size());
                resB = environment.getResource(residB);
                Assert.assertNotNull((String)"Resource in environment", (Object)resB);
                Wiring wiringB = (Wiring)wirings.get(resB);
                Assert.assertNotNull((String)"Wiring in environment", (Object)wiringB);
                Assert.assertEquals((String)"One required wires", (long)1L, (long)wiringB.getRequiredResourceWires(null).size());
                Assert.assertEquals((String)"Zero provided wires", (long)0L, (long)wiringB.getProvidedResourceWires(null).size());
            }
            finally {
                for (ResourceHandle handle : handles) {
                    handle.uninstall();
                }
            }
        }
        finally {
            repository.removeResource(resB.getIdentity());
        }
    }

    private String performCall(String context, String path) throws Exception {
        return this.performCall(context, path, null, 2L, TimeUnit.SECONDS);
    }

    private String performCall(String context, String path, Map<String, String> headers, long timeout, TimeUnit unit) throws Exception {
        return HttpRequest.get("http://localhost:8080" + context + path, headers, timeout, unit);
    }

    @Deployment(name="deploymentB", managed=false, testable=false)
    public static Archive<?> getDeployment() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deploymentB.war");
        archive.addClasses(new Class[]{AnnotatedProxyServlet.class, AnnotatedProxyListener.class});
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformActivator.class, ModuleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.DEPLOYMENT_B);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addManifestHeader("Module-Activator", CamelTransformActivator.class.getName());
                    builder.addImportPackages(new Class[]{ModuleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.DEPLOYMENT_B, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformActivator.class.getName());
                builder.addManifestHeader("Dependencies", "org.apache.camel.core");
                return builder.openStream();
            }
        });
        File[] libs = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.felix:org.apache.felix.http.proxy")).withoutTransitivity()).asFile();
        archive.addAsLibraries(libs);
        return archive;
    }

    @Deployment(name="resourceB", managed=false, testable=false)
    public static Archive<?> getRepositoryResource() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceB.war");
        archive.addClasses(new Class[]{AnnotatedProxyServlet.class, AnnotatedProxyListener.class});
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformActivator.class, ModuleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_B);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addManifestHeader("Module-Activator", CamelTransformActivator.class.getName());
                    builder.addImportPackages(new Class[]{ModuleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_B, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformActivator.class.getName());
                return builder.openStream();
            }
        });
        File[] libs = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.felix:org.apache.felix.http.proxy")).withoutTransitivity()).asFile();
        archive.addAsLibraries(libs);
        return archive;
    }

    public static class Setup
    extends ContainerSetupTask {
        protected String[] getInitialFeatureNames() {
            return new String[]{"camel.core"};
        }
    }
}

