/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests.sub.d;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.test.gravia.itests.sub.d1.ServiceD1;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceD.class}, immediate=true)
public class ServiceD {
    static AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    final String name = this.getClass().getSimpleName() + "#" + INSTANCE_COUNT.incrementAndGet();
    final AtomicReference<ServiceD1> ref = new AtomicReference();
    final CountDownLatch activateLatch = new CountDownLatch(1);
    final CountDownLatch deactivateLatch = new CountDownLatch(1);

    @Activate
    void activate(ComponentContext context) {
        this.activateLatch.countDown();
    }

    @Deactivate
    void deactivate() {
        this.deactivateLatch.countDown();
    }

    public boolean awaitActivate(long timeout, TimeUnit unit) throws InterruptedException {
        return this.activateLatch.await(timeout, unit);
    }

    public boolean awaitDeactivate(long timeout, TimeUnit unit) throws InterruptedException {
        return this.deactivateLatch.await(timeout, unit);
    }

    @Reference
    void bindServiceD1(ServiceD1 service) {
        this.ref.set(service);
    }

    void unbindServiceD1(ServiceD1 service) {
        this.ref.compareAndSet(service, null);
    }

    public ServiceD1 getServiceD1() {
        return this.ref.get();
    }

    public String doStuff(String msg) {
        ServiceD1 srv = this.ref.get();
        return this.name + ":" + srv.doStuff(msg);
    }

    public String toString() {
        return this.name;
    }
}

