/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.gravia.arquillian.container.ContainerSetup;
import org.jboss.gravia.arquillian.container.ContainerSetupTask;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resolver.Resolver;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.IdentityRequirementBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceBuilder;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleActivatorBridge;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.gravia.runtime.WebAppContextListener;
import org.jboss.gravia.runtime.Wiring;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.test.gravia.itests.sub.b.CamelTransformHttpActivator;
import org.jboss.test.gravia.itests.sub.b.SimpleModuleActivator;
import org.jboss.test.gravia.itests.sub.b1.SimpleModuleState;
import org.jboss.test.gravia.itests.support.AnnotatedContextListener;
import org.jboss.test.gravia.itests.support.AnnotatedProxyListener;
import org.jboss.test.gravia.itests.support.AnnotatedProxyServlet;
import org.jboss.test.gravia.itests.support.ArchiveBuilder;
import org.jboss.test.gravia.itests.support.HttpRequest;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.http.HttpService;

@RunWith(value=Arquillian.class)
@ContainerSetup(value={Setup.class})
public class ProvisionerServiceTest {
    static final String RESOURCE_A = "stream-resource";
    static final String RESOURCE_B = "shared-stream-resource";
    static final String RESOURCE_B1 = "shared-stream-resource-client";
    static final String RESOURCE_C = "resourceC";
    static final String RESOURCE_D = "resourceD";
    static final String RESOURCE_E = "resourceE";
    @ArquillianResource
    Deployer deployer;

    @Deployment
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("provisioner-service");
        archive.addClasses(HttpRequest.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, Provisioner.class, Resolver.class, Repository.class});
                    builder.addImportPackages(new Class[]{MBeanServer.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionStreamResource() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        ResourceIdentity identityA = ResourceIdentity.fromString((String)RESOURCE_A);
        ResourceBuilder builderA = provisioner.getContentResourceBuilder(identityA, this.deployer.getDeployment(RESOURCE_A));
        ResourceHandle handle = provisioner.installResource(builderA.getResource());
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            Module module = runtime.getModule(identityA);
            Assert.assertNotNull((String)"Module not null", (Object)module);
            Assert.assertEquals((String)("ACTIVE " + module), (Object)Module.State.ACTIVE, (Object)module.getState());
            MBeanServer server = (MBeanServer)ServiceLocator.getRequiredService(MBeanServer.class);
            Assert.assertTrue((String)"MBean registered", (boolean)server.isRegistered(this.getObjectName(module)));
            Assert.assertEquals((Object)"ACTIVE", (Object)server.getAttribute(this.getObjectName(module), "ModuleState"));
        }
        finally {
            handle.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionSharedStreamResource() throws Exception {
        ArrayList<ResourceHandle> handles = new ArrayList<ResourceHandle>();
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        ResourceIdentity identityB = ResourceIdentity.fromString((String)RESOURCE_B);
        ResourceBuilder builderB = provisioner.getContentResourceBuilder(identityB, this.deployer.getDeployment(RESOURCE_B));
        ResourceIdentity identityB1 = ResourceIdentity.fromString((String)RESOURCE_B1);
        ResourceBuilder builderB1 = provisioner.getContentResourceBuilder(identityB1, this.deployer.getDeployment(RESOURCE_B1));
        handles.add(provisioner.installSharedResource(builderB.getResource()));
        handles.add(provisioner.installResource(builderB1.getResource()));
        try {
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            for (ResourceHandle handle : handles) {
                ResourceIdentity identity = handle.getResource().getIdentity();
                Assert.assertSame((Object)handle.getModule(), (Object)runtime.getModule(identity));
                Assert.assertEquals((String)("ACTIVE " + identity), (Object)Module.State.ACTIVE, (Object)handle.getModule().getState());
            }
            Module module = runtime.getModule(identityB1);
            MBeanServer server = (MBeanServer)ServiceLocator.getRequiredService(MBeanServer.class);
            Assert.assertTrue((String)"MBean registered", (boolean)server.isRegistered(this.getObjectName(module)));
            Assert.assertEquals((Object)"ACTIVE", (Object)server.getAttribute(this.getObjectName(module), "ModuleState"));
        }
        finally {
            for (ResourceHandle handle : handles) {
                handle.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionMavenResource() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Assume.assumeFalse((RuntimeType.TOMCAT == RuntimeType.getRuntimeType() ? 1 : 0) != 0);
        ResourceIdentity identityA = ResourceIdentity.fromString((String)"camel.core.unshared");
        MavenCoordinates mavenid = MavenCoordinates.parse((String)"org.apache.camel:camel-core:jar:2.11.0");
        ResourceBuilder builderA = provisioner.getMavenResourceBuilder(identityA, mavenid);
        ResourceHandle handleA = provisioner.installResource(builderA.getResource());
        try {
            Assert.assertSame((Object)handleA.getModule(), (Object)runtime.getModule(identityA));
            Assert.assertEquals((String)("ACTIVE " + identityA), (Object)Module.State.ACTIVE, (Object)handleA.getModule().getState());
        }
        finally {
            handleA.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionSharedMavenResource() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        ResourceIdentity identityA = ResourceIdentity.fromString((String)"camel.core.shared");
        MavenCoordinates mavenid = MavenCoordinates.parse((String)"org.apache.camel:camel-core:jar:2.11.0");
        ResourceBuilder builderA = provisioner.getMavenResourceBuilder(identityA, mavenid);
        builderA.addIdentityRequirement("javax.api");
        builderA.addIdentityRequirement("org.slf4j");
        ResourceHandle handleA = provisioner.installSharedResource(builderA.getResource());
        try {
            Assert.assertSame((Object)handleA.getModule(), (Object)runtime.getModule(identityA));
            Assert.assertEquals((String)("ACTIVE " + identityA), (Object)Module.State.ACTIVE, (Object)handleA.getModule().getState());
            ResourceIdentity identityC = ResourceIdentity.fromString((String)RESOURCE_C);
            ResourceBuilder builderC = provisioner.getContentResourceBuilder(identityC, this.deployer.getDeployment(RESOURCE_C));
            ResourceHandle handleC = provisioner.installResource("resourceC.war", builderC.getResource());
            try {
                String reqspec = "/service?test=Kermit";
                String context = RuntimeType.getRuntimeType() == RuntimeType.KARAF ? "" : "/resourceC";
                Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(context, reqspec));
            }
            finally {
                handleC.uninstall();
            }
        }
        finally {
            handleA.uninstall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionAbstractFeature() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        ResourceIdentity identity = ResourceIdentity.fromString((String)"camel.core.feature:0.0.0");
        Requirement req = new IdentityRequirementBuilder(identity).getRequirement();
        Set result = provisioner.provisionResources(Collections.singleton(req));
        ArrayList<ResourceHandle> handles = new ArrayList<ResourceHandle>(result);
        try {
            Environment environment = provisioner.getEnvironment();
            Map wirings = environment.getWirings();
            ResourceIdentity residA = ResourceIdentity.create((String)"org.apache.camel.core", (String)"2.11.0");
            Resource resA = environment.getResource(residA);
            Assert.assertNotNull((String)"Resource in environment", (Object)resA);
            Wiring wiringA = (Wiring)wirings.get(resA);
            Assert.assertNotNull((String)"Wiring in environment", (Object)wiringA);
            Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
            DefaultResourceBuilder builder = new DefaultResourceBuilder();
            ResourceIdentity residB = ResourceIdentity.create((String)RESOURCE_D, (Version)Version.emptyVersion);
            Capability icap = builder.addIdentityCapability(residB);
            icap.getAttributes().put("runtime.name", "resourceD.war");
            builder.addContentCapability(this.deployer.getDeployment(RESOURCE_D));
            Resource resB = builder.getResource();
            handles.add(provisioner.installResource(resB));
            Assert.assertTrue((String)"At least one resource", (handles.size() > 0 ? 1 : 0) != 0);
            String reqspec = "/service?test=Kermit";
            String context = RuntimeType.getRuntimeType() == RuntimeType.KARAF ? "" : "/resourceD";
            Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(context, reqspec));
            Runtime runtime = RuntimeLocator.getRequiredRuntime();
            Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residA));
            Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residB));
            wirings = environment.getWirings();
            resA = environment.getResource(residA);
            Assert.assertNotNull((String)"Resource in environment", (Object)resA);
            wiringA = (Wiring)wirings.get(resA);
            Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
            resB = environment.getResource(residB);
            Assert.assertNotNull((String)"Resource in environment", (Object)resB);
            Wiring wiringB = (Wiring)wirings.get(resB);
            Assert.assertNull((String)"Wiring not in environment", (Object)wiringB);
        }
        finally {
            for (ResourceHandle handle : handles) {
                handle.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProvisionRepositoryResourceWithDependency() throws Exception {
        Provisioner provisioner = (Provisioner)ServiceLocator.getRequiredService(Provisioner.class);
        DefaultResourceBuilder builder = new DefaultResourceBuilder();
        Capability icap = builder.addIdentityCapability(RESOURCE_E, Version.emptyVersion);
        icap.getAttributes().put("runtime.name", "resourceE.war");
        builder.addContentCapability(this.deployer.getDeployment(RESOURCE_E));
        builder.addIdentityRequirement("org.apache.camel.core", new VersionRange("[2.11,3.0)"));
        Resource res = builder.getResource();
        Resource resB = provisioner.getRepository().addResource(res);
        Assert.assertEquals((Object)"resourceE:0.0.0", (Object)resB.getIdentity().toString());
        try {
            Requirement req = new IdentityRequirementBuilder(resB.getIdentity()).getRequirement();
            Set result = provisioner.provisionResources(Collections.singleton(req));
            ArrayList handles = new ArrayList(result);
            try {
                String reqspec = "/service?test=Kermit";
                String context = RuntimeType.getRuntimeType() == RuntimeType.KARAF ? "" : "/resourceE";
                Assert.assertEquals((Object)"Hello Kermit", (Object)this.performCall(context, reqspec));
                Runtime runtime = RuntimeLocator.getRequiredRuntime();
                ResourceIdentity residA = ResourceIdentity.create((String)"org.apache.camel.core", (String)"2.11.0");
                Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residA));
                ResourceIdentity residB = ResourceIdentity.create((String)RESOURCE_E, (Version)Version.emptyVersion);
                Assert.assertNotNull((String)"Module available", (Object)runtime.getModule(residB));
                Environment environment = provisioner.getEnvironment();
                Map wirings = environment.getWirings();
                Resource resA = environment.getResource(residA);
                Assert.assertNotNull((String)"Resource in environment", (Object)resA);
                Wiring wiringA = (Wiring)wirings.get(resA);
                Assert.assertNotNull((String)"Wiring in environment", (Object)wiringA);
                Assert.assertEquals((String)"Two required wires", (long)2L, (long)wiringA.getRequiredResourceWires(null).size());
                Assert.assertEquals((String)"One provided wires", (long)1L, (long)wiringA.getProvidedResourceWires(null).size());
                resB = environment.getResource(residB);
                Assert.assertNotNull((String)"Resource in environment", (Object)resB);
                Wiring wiringB = (Wiring)wirings.get(resB);
                Assert.assertNotNull((String)"Wiring in environment", (Object)wiringB);
                Assert.assertEquals((String)"One required wires", (long)1L, (long)wiringB.getRequiredResourceWires(null).size());
                Assert.assertEquals((String)"Zero provided wires", (long)0L, (long)wiringB.getProvidedResourceWires(null).size());
            }
            finally {
                for (ResourceHandle handle : handles) {
                    handle.uninstall();
                }
            }
        }
        finally {
            provisioner.getRepository().removeResource(resB.getIdentity());
        }
    }

    private String performCall(String context, String path) throws Exception {
        return this.performCall(context, path, null, 2L, TimeUnit.SECONDS);
    }

    private String performCall(String context, String path, Map<String, String> headers, long timeout, TimeUnit unit) throws Exception {
        return HttpRequest.get("http://localhost:8080" + context + path, headers, timeout, unit);
    }

    private ObjectName getObjectName(Module module) throws MalformedObjectNameException {
        ResourceIdentity identity = module.getIdentity();
        return new ObjectName("test:name=" + identity.getSymbolicName() + ",version=" + identity.getVersion());
    }

    @Deployment(name="stream-resource", managed=false, testable=false)
    public static Archive<?> getResourceA() {
        ArchiveBuilder archive = new ArchiveBuilder(RESOURCE_A);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class, WebAppContextListener.class);
        archive.addClasses(RuntimeType.KARAF, ModuleActivatorBridge.class);
        archive.addClasses(SimpleModuleActivator.class, SimpleModuleState.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_A);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", SimpleModuleActivator.class.getName());
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, ServiceLocator.class, MBeanServer.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_A, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", SimpleModuleActivator.class.getName());
                builder.addManifestHeader("Dependencies", "org.jboss.gravia");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Deployment(name="shared-stream-resource", managed=false, testable=false)
    public static Archive<?> getResourceB() {
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"shared-stream-resource.jar");
        archive.addClasses(new Class[]{SimpleModuleState.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_B);
                builder.addExportPackages(new Class[]{SimpleModuleState.class});
                builder.addImportPackages(new Class[]{Runtime.class, Resource.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Deployment(name="shared-stream-resource-client", managed=false, testable=false)
    public static Archive<?> getResourceB1() {
        ArchiveBuilder archive = new ArchiveBuilder(RESOURCE_B1);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class, WebAppContextListener.class);
        archive.addClasses(RuntimeType.KARAF, ModuleActivatorBridge.class);
        archive.addClasses(SimpleModuleActivator.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_B1);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Module-Activator", SimpleModuleActivator.class.getName());
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, ServiceLocator.class});
                    builder.addImportPackages(new Class[]{MBeanServer.class, SimpleModuleState.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_B1, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", SimpleModuleActivator.class.getName());
                builder.addManifestHeader("Dependencies", "org.jboss.gravia,shared-stream-resource");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Deployment(name="resourceC", managed=false, testable=false)
    public static Archive<?> getResourceC() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceC.war");
        archive.addClasses(new Class[]{AnnotatedProxyServlet.class, AnnotatedProxyListener.class});
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformHttpActivator.class, ModuleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_C);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                    builder.addImportPackages(new Class[]{ModuleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_C, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                builder.addManifestHeader("Dependencies", "camel.core.shared");
                return builder.openStream();
            }
        });
        File[] libs = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.felix:org.apache.felix.http.proxy")).withoutTransitivity()).asFile();
        archive.addAsLibraries(libs);
        return archive;
    }

    @Deployment(name="resourceD", managed=false, testable=false)
    public static Archive<?> getResourceD() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceD.war");
        archive.addClasses(new Class[]{AnnotatedProxyServlet.class, AnnotatedProxyListener.class});
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformHttpActivator.class, ModuleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_D);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                    builder.addImportPackages(new Class[]{ModuleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_D, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                builder.addManifestHeader("Dependencies", "org.apache.camel.core");
                return builder.openStream();
            }
        });
        File[] libs = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.felix:org.apache.felix.http.proxy")).withoutTransitivity()).asFile();
        archive.addAsLibraries(libs);
        return archive;
    }

    @Deployment(name="resourceE", managed=false, testable=false)
    public static Archive<?> getResourceE() {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"resourceE.war");
        archive.addClasses(new Class[]{AnnotatedProxyServlet.class, AnnotatedProxyListener.class});
        archive.addClasses(new Class[]{AnnotatedContextListener.class, WebAppContextListener.class});
        archive.addClasses(new Class[]{CamelTransformHttpActivator.class, ModuleActivatorBridge.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(ProvisionerServiceTest.RESOURCE_E);
                    builder.addBundleActivator(ModuleActivatorBridge.class);
                    builder.addManifestHeader("Gravia-Enabled", Boolean.TRUE.toString());
                    builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                    builder.addImportPackages(new Class[]{ModuleActivatorBridge.class, Runtime.class, Servlet.class, HttpServlet.class, HttpService.class});
                    builder.addImportPackages(new Class[]{CamelContext.class, DefaultCamelContext.class, RouteBuilder.class, RouteDefinition.class});
                    builder.addBundleClasspath("WEB-INF/classes");
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(ProvisionerServiceTest.RESOURCE_E, Version.emptyVersion);
                builder.addManifestHeader("Module-Activator", CamelTransformHttpActivator.class.getName());
                return builder.openStream();
            }
        });
        File[] libs = ((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.apache.felix:org.apache.felix.http.proxy")).withoutTransitivity()).asFile();
        archive.addAsLibraries(libs);
        return archive;
    }

    public static class Setup
    extends ContainerSetupTask {
        protected String[] getInitialFeatureNames() {
            return new String[]{"camel.core"};
        }
    }
}

