/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.test.gravia.itests.support.AnnotatedContextListener;
import org.jboss.test.gravia.itests.support.ArchiveBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ModuleLifecycleTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("simple");
        archive.addClasses(ModuleLifecycleTest.class);
        archive.addClasses(RuntimeType.TOMCAT, AnnotatedContextListener.class);
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{RuntimeLocator.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Test
    public void testModuleLifecycle() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module modA = runtime.getModule(this.getClass().getClassLoader());
        Assert.assertEquals((Object)Module.State.ACTIVE, (Object)modA.getState());
        ModuleContext context = modA.getModuleContext();
        ServiceRegistration sreg = context.registerService(String.class, (Object)new String("Hello"), null);
        Assert.assertNotNull((String)"Null sreg", (Object)sreg);
        String service = (String)context.getService(sreg.getReference());
        Assert.assertEquals((Object)"Hello", (Object)service);
        modA.stop();
        Assert.assertEquals((Object)Module.State.INSTALLED, (Object)modA.getState());
        modA.uninstall();
        Assert.assertEquals((Object)Module.State.UNINSTALLED, (Object)modA.getState());
        try {
            modA.start();
            Assert.fail((String)"IllegalStateException expected");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }
}

