/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.gravia.itests;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.arquillian.container.ContainerSetup;
import org.jboss.gravia.arquillian.container.ContainerSetupTask;
import org.jboss.gravia.repository.Repository;
import org.jboss.gravia.resource.IdentityRequirementBuilder;
import org.jboss.gravia.resource.ManifestBuilder;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceLocator;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.test.gravia.itests.support.ArchiveBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@ContainerSetup(value={Setup.class})
public class RepositoryServiceTest {
    @Deployment
    public static Archive<?> deployment() {
        final ArchiveBuilder archive = new ArchiveBuilder("repository-service");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                if (ArchiveBuilder.getTargetContainer() == RuntimeType.KARAF) {
                    OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                    builder.addBundleManifestVersion(2);
                    builder.addBundleSymbolicName(archive.getName());
                    builder.addBundleVersion("1.0.0");
                    builder.addImportPackages(new Class[]{Runtime.class, Resource.class, Repository.class});
                    return builder.openStream();
                }
                ManifestBuilder builder = new ManifestBuilder();
                builder.addIdentityCapability(archive.getName(), "1.0.0");
                return builder.openStream();
            }
        });
        return archive.getArchive();
    }

    @Test
    public void testRepositoryContent() throws Exception {
        Requirement freq = new IdentityRequirementBuilder("camel.core.feature", (String)null).getRequirement();
        Repository repository = (Repository)ServiceLocator.getRequiredService(Repository.class);
        Collection providers = repository.findProviders(freq);
        Assert.assertEquals((String)"One provider", (long)1L, (long)providers.size());
    }

    public static class Setup
    extends ContainerSetupTask {
        Set<ResourceIdentity> identities;

        protected void setUp(ContainerSetupTask.Context context) throws Exception {
            String resname = "META-INF/repository-content/camel.core.feature.xml";
            URL resurl = ((Object)((Object)this)).getClass().getClassLoader().getResource(resname);
            this.identities = this.addRepositoryContent(context, resurl);
        }

        protected void tearDown(ContainerSetupTask.Context context) throws Exception {
            this.removeRepositoryContent(context, this.identities);
        }
    }
}

